/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.GuiBasic;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.buttons.GuiMultiButton;
import mods.railcraft.common.blocks.signals.TileBoxCapacitor;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;

public class GuiBoxCapacitor
extends GuiBasic {
    private final TileBoxCapacitor tile;
    private short ticksToPower;
    private GuiMultiButton stateMode;

    public GuiBoxCapacitor(TileBoxCapacitor tile) {
        super(tile.getName());
        this.tile = tile;
        this.ticksToPower = tile.ticksToPower;
    }

    public void initGui() {
        if (this.tile == null) {
            return;
        }
        this.buttonList.clear();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        this.buttonList.add(new GuiButton(0, w + 13, h + 38, 30, 20, "-10"));
        this.buttonList.add(new GuiButton(1, w + 53, h + 38, 30, 20, "-1"));
        this.buttonList.add(new GuiButton(2, w + 93, h + 38, 30, 20, "+1"));
        this.buttonList.add(new GuiButton(3, w + 133, h + 38, 30, 20, "+10"));
        this.stateMode = new GuiMultiButton(4, w + 23, h + 65, 130, this.tile.getStateModeController().copy());
        this.buttonList.add(this.stateMode);
    }

    @Override
    protected void drawExtras(int x, int y, float f) {
        GuiTools.drawCenteredString(this.fontRendererObj, LocalizationPlugin.translate("railcraft.gui.box.capacitor.duration", this.ticksToPower / 20), 25);
    }

    protected void actionPerformed(GuiButton guibutton) {
        short ticks = this.ticksToPower;
        if (guibutton.id == 0) {
            ticks = (short)(ticks - 200);
        }
        if (guibutton.id == 1) {
            ticks = (short)(ticks - 20);
        }
        if (guibutton.id == 2) {
            ticks = (short)(ticks + 20);
        }
        if (guibutton.id == 3) {
            ticks = (short)(ticks + 200);
        }
        if (ticks < 0) {
            ticks = 0;
        }
        this.ticksToPower = ticks;
    }

    public void onGuiClosed() {
        if (Game.isNotHost(this.tile.getWorld())) {
            this.tile.ticksToPower = this.ticksToPower;
            this.tile.getStateModeController().setCurrentState(this.stateMode.getController().getCurrentState());
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendToServer(pkt);
        }
    }
}

