/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.EntityGui;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.gui.containers.ContainerBore;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;

public class GuiCartBore
extends EntityGui {
    private final String HEAD = LocalizationPlugin.translate("railcraft.gui.bore.head");
    private final String FUEL = LocalizationPlugin.translate("railcraft.gui.bore.fuel");
    private final String BALLAST = LocalizationPlugin.translate("railcraft.gui.bore.ballast");
    private final String TRACK = LocalizationPlugin.translate("railcraft.gui.bore.track");
    private EntityTunnelBore cart;

    public GuiCartBore(InventoryPlayer inv, EntityTunnelBore cart) {
        super((Entity)cart, new ContainerBore(inv, cart), "railcraft:textures/gui/gui_bore.png");
        this.cart = cart;
        this.xSize = 176;
        this.ySize = 222;
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        GuiTools.drawCenteredString(this.fontRendererObj, this.cart.getCommandSenderName(), 6);
        this.fontRendererObj.drawString(this.HEAD, 13, 26, 0x404040);
        this.fontRendererObj.drawString(this.FUEL, 64, 26, 0x404040);
        this.fontRendererObj.drawString(this.BALLAST, 10, 62, 0x404040);
        this.fontRendererObj.drawString(this.TRACK, 10, 98, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        super.drawGuiContainerBackgroundLayer(f, i, j);
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        if (this.cart.getFuel() > 0) {
            int burnProgress = this.cart.getBurnProgressScaled(12);
            this.drawTexturedModalRect(w + 44, h + 48 - burnProgress, 176, 12 - burnProgress, 14, burnProgress + 2);
        }
    }
}

