/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.GuiBasic;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.common.carts.CartExplosiveBase;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.client.gui.GuiButton;

public class GuiCartTNTFuse
extends GuiBasic {
    private final String FUSE = LocalizationPlugin.translate("railcraft.gui.cart.tnt.fuse") + " = ";
    private final String TICKS = " " + LocalizationPlugin.translate("railcraft.gui.ticks");
    protected int fuse = 80;
    CartExplosiveBase cart;

    public GuiCartTNTFuse(CartExplosiveBase c) {
        super(c.getCommandSenderName());
        this.cart = c;
        if (this.cart != null) {
            this.fuse = this.cart.getFuse();
        }
    }

    public void initGui() {
        this.buttonList.clear();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        this.buttonList.add(new GuiButton(0, w + 13, h + 50, 30, 20, "-10"));
        this.buttonList.add(new GuiButton(1, w + 53, h + 50, 30, 20, "-1"));
        this.buttonList.add(new GuiButton(2, w + 93, h + 50, 30, 20, "+1"));
        this.buttonList.add(new GuiButton(3, w + 133, h + 50, 30, 20, "+10"));
    }

    protected void actionPerformed(GuiButton guibutton) {
        int f = this.fuse;
        if (guibutton.id == 0) {
            f -= 10;
        }
        if (guibutton.id == 1) {
            --f;
        }
        if (guibutton.id == 2) {
            ++f;
        }
        if (guibutton.id == 3) {
            f += 10;
        }
        if (f < 0) {
            f = 0;
        }
        if (f > 500) {
            f = 500;
        }
        this.fuse = f;
    }

    @Override
    public void drawExtras(int x, int y, float f) {
        if (this.cart != null) {
            GuiTools.drawCenteredString(this.fontRendererObj, this.FUSE + this.fuse + this.TICKS, 25);
        }
    }

    public void onGuiClosed() {
        this.cart.setFuse(this.fuse);
        if (Game.isNotHost(this.cart.getWorld())) {
            PacketBuilder.instance().sendGuiReturnPacket(this.cart);
        }
    }
}

