/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import java.util.ArrayList;
import mods.railcraft.client.gui.GuiBasic;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.buttons.GuiToggleButton;
import mods.railcraft.common.blocks.detector.TileDetector;
import mods.railcraft.common.blocks.detector.types.DetectorAnimal;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;

public class GuiDetectorAnimal
extends GuiBasic {
    private final TileDetector tile;
    private final DetectorAnimal detector;

    protected GuiDetectorAnimal(TileDetector tile) {
        super(tile.getName(), "railcraft:textures/gui/gui_long.png", 256, 88);
        this.tile = tile;
        this.detector = (DetectorAnimal)tile.getDetector();
    }

    public void initGui() {
        if (this.tile == null) {
            return;
        }
        this.buttonList.clear();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        ArrayList<GuiToggleButton> row1 = new ArrayList<GuiToggleButton>();
        row1.add(new GuiToggleButton(0, 0, h + 25, 50, "Chicken", this.detector.chicken));
        row1.add(new GuiToggleButton(1, 0, h + 25, 50, "Cow", this.detector.cow));
        row1.add(new GuiToggleButton(2, 0, h + 25, 50, "Pig", this.detector.pig));
        row1.add(new GuiToggleButton(3, 0, h + 25, 50, "Sheep", this.detector.sheep));
        GuiTools.newButtonRowAuto(this.buttonList, w, this.xSize, row1);
        ArrayList<GuiToggleButton> row2 = new ArrayList<GuiToggleButton>();
        row2.add(new GuiToggleButton(4, 0, h + 55, 50, "Wolf", this.detector.wolf));
        row2.add(new GuiToggleButton(5, 0, h + 55, 70, "Mooshroom", this.detector.mooshroom));
        row2.add(new GuiToggleButton(6, 0, h + 55, 50, "Other", this.detector.other));
        GuiTools.newButtonRowAuto(this.buttonList, w, this.xSize, row2);
    }

    protected void actionPerformed(GuiButton button) {
        if (this.tile == null) {
            return;
        }
        switch (button.id) {
            case 0: {
                ((GuiToggleButton)button).active = this.detector.chicken = !this.detector.chicken;
                break;
            }
            case 1: {
                ((GuiToggleButton)button).active = this.detector.cow = !this.detector.cow;
                break;
            }
            case 2: {
                ((GuiToggleButton)button).active = this.detector.pig = !this.detector.pig;
                break;
            }
            case 3: {
                ((GuiToggleButton)button).active = this.detector.sheep = !this.detector.sheep;
                break;
            }
            case 4: {
                ((GuiToggleButton)button).active = this.detector.wolf = !this.detector.wolf;
                break;
            }
            case 5: {
                ((GuiToggleButton)button).active = this.detector.mooshroom = !this.detector.mooshroom;
                break;
            }
            case 6: {
                ((GuiToggleButton)button).active = this.detector.other = !this.detector.other;
            }
        }
    }

    public void onGuiClosed() {
        if (Game.isNotHost(this.tile.getWorld())) {
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendToServer(pkt);
        }
    }
}

