/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import java.awt.Color;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiButtonSmall;
import mods.railcraft.common.blocks.detector.TileDetector;
import mods.railcraft.common.blocks.detector.types.DetectorItem;
import mods.railcraft.common.gui.containers.ContainerDetectorItem;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import org.lwjgl.opengl.GL11;

public class GuiDetectorItem
extends TileGui {
    private final String label;
    private final TileDetector tile;
    private final DetectorItem detector;
    private GuiButton filterLeft;
    private GuiButton filterRight;

    public GuiDetectorItem(InventoryPlayer inv, TileDetector tile) {
        super(tile, new ContainerDetectorItem(inv, tile), "railcraft:textures/gui/gui_detector_item.png");
        this.tile = tile;
        this.detector = (DetectorItem)tile.getDetector();
        this.xSize = 176;
        this.ySize = 166;
        this.label = tile.getName();
    }

    public void initGui() {
        super.initGui();
        if (this.tile == null) {
            return;
        }
        this.buttonList.clear();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        this.buttonList.add(new GuiButtonSmall(0, w + 10, h + 20, 20, "<"));
        this.buttonList.add(new GuiButtonSmall(1, w + 146, h + 20, 20, ">"));
        this.filterLeft = new GuiButtonSmall(2, w + 10, h + 40, 20, "<");
        this.buttonList.add(this.filterLeft);
        this.filterRight = new GuiButtonSmall(3, w + 146, h + 40, 20, ">");
        this.buttonList.add(this.filterRight);
    }

    protected void actionPerformed(GuiButton button) {
        if (this.tile == null) {
            return;
        }
        int primary = this.detector.getPrimaryMode().ordinal();
        int filter = this.detector.getFilterMode().ordinal();
        switch (button.id) {
            case 0: {
                --primary;
                break;
            }
            case 1: {
                ++primary;
                break;
            }
            case 2: {
                --filter;
                break;
            }
            case 3: {
                ++filter;
            }
        }
        if (primary < 0) {
            primary = DetectorItem.PrimaryMode.values().length - 1;
        }
        if (primary >= DetectorItem.PrimaryMode.values().length) {
            primary = 0;
        }
        this.detector.setPrimaryMode(DetectorItem.PrimaryMode.values()[primary]);
        if (filter < 0) {
            filter = DetectorItem.FilterMode.values().length - 1;
        }
        if (filter >= DetectorItem.FilterMode.values().length) {
            filter = 0;
        }
        this.detector.setFilterMode(DetectorItem.FilterMode.values()[filter]);
        if (Game.isNotHost(this.tile.getWorld())) {
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendToServer(pkt);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        this.filterLeft.visible = this.detector.getPrimaryMode() == DetectorItem.PrimaryMode.FILTERED;
        this.filterRight.visible = this.detector.getPrimaryMode() == DetectorItem.PrimaryMode.FILTERED;
        super.drawGuiContainerBackgroundLayer(f, i, j);
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        int sWidth = this.fontRendererObj.getStringWidth(this.label);
        int sPos = this.xSize / 2 - sWidth / 2;
        this.fontRendererObj.drawString(this.label, sPos, 6, 0x404040);
        GuiTools.drawCenteredString(this.fontRendererObj, this.detector.getPrimaryMode().toString(), 25);
        if (this.detector.getPrimaryMode() != DetectorItem.PrimaryMode.FILTERED) {
            Color color = new Color(0, 0, 0, 80);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            for (int slotNum = 0; slotNum < 9; ++slotNum) {
                Slot slot = (Slot)this.inventorySlots.inventorySlots.get(slotNum);
                int displayX = slot.xDisplayPosition;
                int displayY = slot.yDisplayPosition;
                this.drawGradientRect(displayX, displayY, displayX + 16, displayY + 16, color.getRGB(), color.getRGB());
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        } else {
            GuiTools.drawCenteredString(this.fontRendererObj, this.detector.getFilterMode().toString(), 45);
        }
    }
}

