/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import cpw.mods.fml.common.registry.VillagerRegistry;
import mods.railcraft.client.gui.GuiBasic;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.buttons.GuiToggleButtonSmall;
import mods.railcraft.common.blocks.detector.TileDetector;
import mods.railcraft.common.blocks.detector.types.DetectorVillager;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.collections.RevolvingList;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.passive.EntityVillager;

public class GuiDetectorVillager
extends GuiBasic {
    private final TileDetector tile;
    private final DetectorVillager detector;
    private final EntityVillager villager;
    private DetectorVillager.Mode mode;
    private GuiToggleButtonSmall any;
    private GuiToggleButtonSmall none;
    private GuiToggleButtonSmall equals;
    private GuiToggleButtonSmall not;
    private final RevolvingList<Integer> professions = new RevolvingList();

    public GuiDetectorVillager(TileDetector t) {
        super(t.getName(), "railcraft:textures/gui/gui_detector_villager.png", 176, 105);
        this.tile = t;
        this.detector = (DetectorVillager)this.tile.getDetector();
        this.villager = new EntityVillager(this.tile.getWorld());
        this.mode = this.detector.getMode();
        for (int prof = 0; prof < 5; ++prof) {
            this.professions.add(prof);
        }
        this.professions.addAll(VillagerRegistry.getRegisteredVillagers());
        this.professions.setCurrent(this.detector.getProfession());
        this.villager.setProfession(this.professions.getCurrent().intValue());
    }

    public void initGui() {
        if (this.tile == null) {
            return;
        }
        this.buttonList.clear();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        this.buttonList.add(new GuiButton(0, w + 10, h + 25, 30, 20, "<"));
        this.buttonList.add(new GuiButton(1, w + 135, h + 25, 30, 20, ">"));
        this.any = new GuiToggleButtonSmall(2, w + 10, h + 55, 45, LocalizationPlugin.translate("railcraft.gui.detector.villager.any"), this.mode == DetectorVillager.Mode.ANY);
        this.buttonList.add(this.any);
        this.none = new GuiToggleButtonSmall(3, w + 10, h + 75, 45, LocalizationPlugin.translate("railcraft.gui.detector.villager.none"), this.mode == DetectorVillager.Mode.NONE);
        this.buttonList.add(this.none);
        this.equals = new GuiToggleButtonSmall(4, w + 122, h + 55, 45, LocalizationPlugin.translate("railcraft.gui.detector.villager.equals"), this.mode == DetectorVillager.Mode.EQUALS);
        this.buttonList.add(this.equals);
        this.not = new GuiToggleButtonSmall(5, w + 122, h + 75, 45, LocalizationPlugin.translate("railcraft.gui.detector.villager.not"), this.mode == DetectorVillager.Mode.NOT);
        this.buttonList.add(this.not);
    }

    @Override
    protected void drawExtras(int x, int y, float f) {
        int guiLeft = (this.width - this.xSize) / 2;
        int guiTop = (this.height - this.ySize) / 2;
        GuiTools.drawVillager(this.villager, 87, 91, 30, (float)(guiLeft + 87) - (float)x, (float)(guiTop + 91 - 50) - (float)y);
    }

    protected void actionPerformed(GuiButton button) {
        if (this.tile == null) {
            return;
        }
        switch (button.id) {
            case 0: {
                this.professions.rotateLeft();
                break;
            }
            case 1: {
                this.professions.rotateRight();
                break;
            }
            case 2: {
                this.mode = DetectorVillager.Mode.ANY;
                break;
            }
            case 3: {
                this.mode = DetectorVillager.Mode.NONE;
                break;
            }
            case 4: {
                this.mode = DetectorVillager.Mode.EQUALS;
                break;
            }
            case 5: {
                this.mode = DetectorVillager.Mode.NOT;
            }
        }
        this.any.active = this.mode == DetectorVillager.Mode.ANY;
        this.none.active = this.mode == DetectorVillager.Mode.NONE;
        this.equals.active = this.mode == DetectorVillager.Mode.EQUALS;
        this.not.active = this.mode == DetectorVillager.Mode.NOT;
        this.villager.setProfession(this.professions.getCurrent().intValue());
    }

    public void onGuiClosed() {
        if (Game.isNotHost(this.tile.getWorld())) {
            this.detector.setProfession(this.professions.getCurrent());
            this.detector.setMode(this.mode);
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendToServer(pkt);
        }
    }
}

