/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiToggleButton;
import mods.railcraft.common.blocks.machine.gamma.TileEnergyLoader;
import mods.railcraft.common.gui.containers.ContainerEnergyLoader;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;

public class GuiLoaderEnergy
extends TileGui {
    private final String BUTTON1 = LocalizationPlugin.translate("railcraft.gui.energy.loader.empty");
    private final String BUTTON2 = LocalizationPlugin.translate("railcraft.gui.energy.loader.fill");
    private TileEnergyLoader tile;
    private boolean waitIfEmpty;
    private boolean waitTillFull;

    public GuiLoaderEnergy(InventoryPlayer inv, TileEnergyLoader tile) {
        super(tile, new ContainerEnergyLoader(inv, tile), "railcraft:textures/gui/gui_energy_loader.png");
        this.tile = tile;
        this.waitIfEmpty = tile.waitIfEmpty();
        this.waitTillFull = tile.waitTillFull();
    }

    public void initGui() {
        super.initGui();
        if (this.tile == null) {
            return;
        }
        this.buttonList.clear();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        this.buttonList.add(new GuiToggleButton(0, w + 75, h + 18, 70, this.BUTTON1, this.waitIfEmpty));
        this.buttonList.add(new GuiToggleButton(1, w + 75, h + 42, 70, this.BUTTON2, this.waitTillFull));
    }

    protected void actionPerformed(GuiButton guibutton) {
        if (this.tile == null) {
            return;
        }
        if (guibutton.id == 0) {
            boolean bl = this.waitIfEmpty = !this.waitIfEmpty;
            if (!this.waitIfEmpty) {
                this.waitTillFull = false;
            }
            ((GuiToggleButton)guibutton).active = this.waitIfEmpty;
            ((GuiToggleButton)((Object)this.buttonList.get((int)1))).active = this.waitTillFull;
        }
        if (guibutton.id == 1) {
            boolean bl = this.waitTillFull = !this.waitTillFull;
            if (this.waitTillFull) {
                this.waitIfEmpty = true;
            }
            ((GuiToggleButton)((Object)this.buttonList.get((int)0))).active = this.waitIfEmpty;
            ((GuiToggleButton)guibutton).active = this.waitTillFull;
        }
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        int sWidth = this.fontRendererObj.getStringWidth(this.tile.getName());
        int sPos = this.xSize / 2 - sWidth / 2;
        this.fontRendererObj.drawString(this.tile.getName(), sPos, 6, 0x404040);
        this.fontRendererObj.drawString(Integer.toString((int)this.tile.getEnergy()), 30, 55, 0x404040);
        String capacity = "/" + this.tile.getCapacity();
        this.fontRendererObj.drawString(capacity, 28, 65, 0x404040);
        this.fontRendererObj.drawString(LocalizationPlugin.translate("railcraft.gui.ic2.energy.rate", this.tile.getTransferRate()), 80, 67, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        super.drawGuiContainerBackgroundLayer(f, i, j);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        if (this.tile.getEnergy() > 0.0) {
            int energy = this.tile.getEnergyBarScaled(24);
            this.drawTexturedModalRect(x + 31, y + 34, 176, 14, energy, 17);
        }
    }

    public void onGuiClosed() {
        if (Game.isNotHost(this.tile.getWorld())) {
            this.tile.setWaitIfEmpty(this.waitIfEmpty);
            this.tile.setWaitTillFull(this.waitTillFull);
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendToServer(pkt);
        }
    }

    public void updateScreen() {
        super.updateScreen();
        TileEntity t = this.tile.getWorld().getTileEntity(this.tile.getX(), this.tile.getY(), this.tile.getZ());
        if (t instanceof TileEnergyLoader) {
            this.tile = (TileEnergyLoader)t;
        } else {
            this.mc.thePlayer.closeScreen();
        }
    }
}

