/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiMultiButton;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderItemBase;
import mods.railcraft.common.gui.containers.ContainerItemLoader;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.InventoryPlayer;

public class GuiLoaderItem
extends TileGui {
    private final String FILTER_LABEL = LocalizationPlugin.translate("railcraft.gui.filters");
    private final String CART_FILTER_LABEL = LocalizationPlugin.translate("railcraft.gui.filters.carts");
    private final String BUFFER_LABEL = LocalizationPlugin.translate("railcraft.gui.item.loader.buffer");
    private GuiMultiButton transferMode;
    private GuiMultiButton redstoneMode;
    private final TileLoaderItemBase tile;

    public GuiLoaderItem(InventoryPlayer inv, TileLoaderItemBase tile) {
        super(tile, new ContainerItemLoader(inv, tile), "railcraft:textures/gui/gui_item_loader.png");
        this.tile = tile;
    }

    public void initGui() {
        super.initGui();
        if (this.tile == null) {
            return;
        }
        this.buttonList.clear();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        this.transferMode = new GuiMultiButton(0, w + 62, h + 45, 52, this.tile.getTransferModeController().copy());
        this.buttonList.add(this.transferMode);
        this.redstoneMode = new GuiMultiButton(0, w + 62, h + 62, 52, this.tile.getRedstoneModeController().copy());
        this.buttonList.add(this.redstoneMode);
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        GuiTools.drawCenteredString(this.fontRendererObj, this.tile.getName(), 6);
        this.fontRendererObj.drawString(this.FILTER_LABEL, 18, 16, 0x404040);
        this.fontRendererObj.drawString(this.CART_FILTER_LABEL, 75, 16, 0x404040);
        this.fontRendererObj.drawString(this.BUFFER_LABEL, 126, 16, 0x404040);
    }

    public void onGuiClosed() {
        if (Game.isNotHost(this.tile.getWorld())) {
            this.tile.getTransferModeController().setCurrentState(this.transferMode.getController().getCurrentState());
            this.tile.getRedstoneModeController().setCurrentState(this.redstoneMode.getController().getCurrentState());
            PacketBuilder.instance().sendGuiReturnPacket(this.tile);
        }
    }
}

