/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import java.util.ArrayList;
import mods.railcraft.client.gui.EntityGui;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.buttons.GuiMultiButton;
import mods.railcraft.client.gui.buttons.GuiToggleButtonSmall;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.gui.containers.ContainerLocomotive;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.StatCollector;

public abstract class GuiLocomotive
extends EntityGui {
    private final EntityLocomotive loco;
    private final EntityPlayer player;
    private final boolean hasIdleMode;
    private final String typeTag;
    private GuiToggleButtonSmall running;
    private GuiToggleButtonSmall idle;
    private GuiToggleButtonSmall shutdown;
    private GuiToggleButtonSmall reverse;
    private GuiToggleButtonSmall slowest;
    private GuiToggleButtonSmall slower;
    private GuiToggleButtonSmall slow;
    private GuiToggleButtonSmall max;
    private GuiMultiButton lockButton;
    private ToolTip lockedToolTips;
    private ToolTip unlockedToolTips;
    private ToolTip privateToolTips;
    private String locoOwner;

    public GuiLocomotive(InventoryPlayer inv, EntityLocomotive loco, ContainerLocomotive container, String typeTag, String guiName, int guiHeight, boolean hasIdleMode) {
        super((Entity)loco, container, "railcraft:textures/gui/" + guiName);
        this.ySize = guiHeight;
        this.loco = loco;
        this.player = inv.player;
        this.typeTag = typeTag;
        this.hasIdleMode = hasIdleMode;
        loco.clientMode = loco.getMode();
        loco.clientSpeed = loco.getSpeed();
        this.lockedToolTips = ToolTip.buildToolTip("railcraft.gui.locomotive.tip.button.locked", "{owner}=[Unknown]");
        this.unlockedToolTips = ToolTip.buildToolTip("railcraft.gui.locomotive.tip.button.unlocked", "{owner}=[Unknown]");
        this.privateToolTips = ToolTip.buildToolTip("railcraft.gui.locomotive.tip.button.private", "{owner}=[Unknown]");
    }

    public void initGui() {
        super.initGui();
        if (this.loco == null) {
            return;
        }
        this.buttonList.clear();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        ArrayList<GuiToggleButtonSmall> buttons = new ArrayList<GuiToggleButtonSmall>();
        this.running = new GuiToggleButtonSmall(0, 0, h + this.ySize - 129, 55, LocalizationPlugin.translate("railcraft.gui.locomotive.mode.running"), this.loco.clientMode == EntityLocomotive.LocoMode.RUNNING);
        buttons.add(this.running);
        this.idle = new GuiToggleButtonSmall(1, 0, h + this.ySize - 129, 45, LocalizationPlugin.translate("railcraft.gui.locomotive.mode.idle"), this.loco.clientMode == EntityLocomotive.LocoMode.IDLE);
        if (this.hasIdleMode) {
            buttons.add(this.idle);
        }
        this.shutdown = new GuiToggleButtonSmall(2, 0, h + this.ySize - 129, 55, LocalizationPlugin.translate("railcraft.gui.locomotive.mode.shutdown"), this.loco.clientMode == EntityLocomotive.LocoMode.SHUTDOWN);
        buttons.add(this.shutdown);
        this.running.setToolTip(ToolTip.buildToolTip("railcraft.gui.locomotive." + this.typeTag + ".tip.button.mode.running", new String[0]));
        this.idle.setToolTip(ToolTip.buildToolTip("railcraft.gui.locomotive." + this.typeTag + ".tip.button.mode.idle", new String[0]));
        this.shutdown.setToolTip(ToolTip.buildToolTip("railcraft.gui.locomotive." + this.typeTag + ".tip.button.mode.shutdown", new String[0]));
        GuiTools.newButtonRowAuto(this.buttonList, w + 3, 171, buttons);
        ArrayList<GuiToggleButtonSmall> speedButtons = new ArrayList<GuiToggleButtonSmall>();
        this.reverse = new GuiToggleButtonSmall(3, 0, h + this.ySize - 112, 12, "<", this.loco.clientSpeed == EntityLocomotive.LocoSpeed.REVERSE);
        speedButtons.add(this.reverse);
        this.slowest = new GuiToggleButtonSmall(4, 0, h + this.ySize - 112, 12, ">", this.loco.clientSpeed == EntityLocomotive.LocoSpeed.SLOWEST);
        speedButtons.add(this.slowest);
        this.slower = new GuiToggleButtonSmall(5, 0, h + this.ySize - 112, 17, ">>", this.loco.clientSpeed == EntityLocomotive.LocoSpeed.SLOWER);
        speedButtons.add(this.slower);
        this.slow = new GuiToggleButtonSmall(6, 0, h + this.ySize - 112, 22, ">>>", this.loco.clientSpeed == EntityLocomotive.LocoSpeed.SLOW);
        speedButtons.add(this.slow);
        this.max = new GuiToggleButtonSmall(7, 0, h + this.ySize - 112, 27, ">>>>", this.loco.clientSpeed == EntityLocomotive.LocoSpeed.MAX);
        speedButtons.add(this.max);
        GuiTools.newButtonRow(this.buttonList, w + 8, 3, speedButtons);
        this.lockButton = new GuiMultiButton(8, w + 152, h + this.ySize - 111, 16, this.loco.getLockController());
        this.buttonList.add(this.lockButton);
        this.lockButton.enabled = this.loco.clientCanLock;
    }

    protected void actionPerformed(GuiButton guibutton) {
        if (this.loco == null) {
            return;
        }
        switch (guibutton.id) {
            case 0: {
                this.loco.clientMode = EntityLocomotive.LocoMode.RUNNING;
                break;
            }
            case 1: {
                this.loco.clientMode = EntityLocomotive.LocoMode.IDLE;
                break;
            }
            case 2: {
                this.loco.clientMode = EntityLocomotive.LocoMode.SHUTDOWN;
                break;
            }
            case 3: {
                this.loco.clientSpeed = EntityLocomotive.LocoSpeed.REVERSE;
                break;
            }
            case 4: {
                this.loco.clientSpeed = EntityLocomotive.LocoSpeed.SLOWEST;
                break;
            }
            case 5: {
                this.loco.clientSpeed = EntityLocomotive.LocoSpeed.SLOWER;
                break;
            }
            case 6: {
                this.loco.clientSpeed = EntityLocomotive.LocoSpeed.SLOW;
                break;
            }
            case 7: {
                this.loco.clientSpeed = EntityLocomotive.LocoSpeed.MAX;
            }
        }
        this.updateButtons();
        this.sendUpdatePacket();
    }

    public void updateScreen() {
        super.updateScreen();
        this.updateButtons();
    }

    private void updateButtons() {
        this.lockButton.enabled = this.loco.clientCanLock;
        this.lockButton.setToolTip(this.loco.isPrivate() ? this.privateToolTips : (this.loco.isSecure() ? this.lockedToolTips : (this.lockButton.enabled ? this.unlockedToolTips : null)));
        String ownerName = ((ContainerLocomotive)this.container).ownerName;
        if (ownerName != null && !ownerName.equals(this.locoOwner)) {
            this.locoOwner = ownerName;
            this.lockedToolTips = ToolTip.buildToolTip("railcraft.gui.locomotive.tip.button.locked", "{owner}=" + ownerName);
            this.unlockedToolTips = ToolTip.buildToolTip("railcraft.gui.locomotive.tip.button.unlocked", "{owner}=" + ownerName);
            this.privateToolTips = ToolTip.buildToolTip("railcraft.gui.locomotive.tip.button.private", "{owner}=" + ownerName);
        }
        this.running.active = this.loco.clientMode == EntityLocomotive.LocoMode.RUNNING;
        this.idle.active = this.loco.clientMode == EntityLocomotive.LocoMode.IDLE;
        this.shutdown.active = this.loco.clientMode == EntityLocomotive.LocoMode.SHUTDOWN;
        this.reverse.active = this.loco.clientSpeed == EntityLocomotive.LocoSpeed.REVERSE;
        this.slowest.active = this.loco.clientSpeed == EntityLocomotive.LocoSpeed.SLOWEST;
        this.slower.active = this.loco.clientSpeed == EntityLocomotive.LocoSpeed.SLOWER;
        this.slow.active = this.loco.clientSpeed == EntityLocomotive.LocoSpeed.SLOW;
        this.max.active = this.loco.clientSpeed == EntityLocomotive.LocoSpeed.MAX;
    }

    public void onGuiClosed() {
        this.sendUpdatePacket();
    }

    private void sendUpdatePacket() {
        PacketBuilder.instance().sendGuiReturnPacket(this.loco);
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        String name = this.loco.getCommandSenderName();
        GuiTools.drawCenteredString(this.fontRendererObj, name, 6);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), 8, this.ySize - 96 + 2, 0x404040);
    }
}

