/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import com.google.common.collect.Lists;
import mods.railcraft.client.gui.GuiAspectAction;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.buttons.GuiToggleButton;
import mods.railcraft.common.blocks.signals.TileSwitchMotor;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;

public class GuiSwitchMotor
extends GuiAspectAction {
    private final TileSwitchMotor switchMotor;
    private boolean shouldSwitchOnRedstone;
    private GuiToggleButton redstoneButton;

    public GuiSwitchMotor(EntityPlayer player, TileSwitchMotor switchMotor, String title) {
        super(player, switchMotor, title, "railcraft:textures/gui/gui_basic_large.png");
        this.switchMotor = switchMotor;
        this.shouldSwitchOnRedstone = switchMotor.shouldSwitchOnRedstone();
        this.ySize = 113;
    }

    @Override
    public void initGui() {
        super.initGui();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        this.redstoneButton = new GuiToggleButton(6, w + 43, h + 80, 100, LocalizationPlugin.translate("railcraft.gui.switch.motor.redstone"), !this.shouldSwitchOnRedstone);
        GuiTools.newButtonRowAuto(this.buttonList, w + 3, 171, Lists.newArrayList((Object[])new GuiToggleButton[]{this.redstoneButton}));
    }

    @Override
    protected void onButtonPressed(GuiButton button) {
        super.onButtonPressed(button);
        if (button == this.redstoneButton) {
            this.shouldSwitchOnRedstone = !this.shouldSwitchOnRedstone;
            ((GuiToggleButton)button).active = !this.shouldSwitchOnRedstone;
        }
    }

    @Override
    protected void prepareForPacket() {
        super.prepareForPacket();
        this.switchMotor.setSwitchOnRedstone(this.shouldSwitchOnRedstone);
    }
}

