/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiToggleButton;
import mods.railcraft.common.blocks.machine.gamma.TileEnergyUnloader;
import mods.railcraft.common.gui.containers.ContainerEnergyLoader;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;

public class GuiUnloaderEnergy
extends TileGui {
    private final String label;
    private final String button1Label = LocalizationPlugin.translate("railcraft.gui.energy.unloader.wait");
    private TileEnergyUnloader tile;

    public GuiUnloaderEnergy(InventoryPlayer inv, TileEnergyUnloader tile) {
        super(tile, new ContainerEnergyLoader(inv, tile), "railcraft:textures/gui/gui_energy_loader.png");
        this.tile = tile;
        this.label = tile.getName();
    }

    public void initGui() {
        super.initGui();
        if (this.tile == null) {
            return;
        }
        this.buttonList.clear();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        this.buttonList.add(new GuiToggleButton(0, w + 75, h + 18, 70, this.button1Label, this.tile.waitTillEmpty()));
    }

    protected void actionPerformed(GuiButton guibutton) {
        if (this.tile == null) {
            return;
        }
        if (guibutton.id == 0) {
            this.tile.setWaitTillEmpty(!this.tile.waitTillEmpty());
            ((GuiToggleButton)guibutton).active = this.tile.waitTillEmpty();
        }
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        int sWidth = this.fontRendererObj.getStringWidth(this.tile.getName());
        int sPos = this.xSize / 2 - sWidth / 2;
        this.fontRendererObj.drawString(this.label, sPos, 6, 0x404040);
        this.fontRendererObj.drawString(Integer.toString((int)this.tile.getEnergy()), 30, 55, 0x404040);
        String capacity = "/" + this.tile.getCapacity();
        this.fontRendererObj.drawString(capacity, 28, 65, 0x404040);
        this.fontRendererObj.drawString(LocalizationPlugin.translate("railcraft.gui.ic2.energy.rate", this.tile.getTransferRate()), 90, 67, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        super.drawGuiContainerBackgroundLayer(f, i, j);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        if (this.tile.getEnergy() > 0.0) {
            int energy = this.tile.getEnergyBarScaled(24);
            this.drawTexturedModalRect(x + 31, y + 34, 176, 14, energy, 17);
        }
    }

    public void onGuiClosed() {
        if (Game.isNotHost(this.tile.getWorld())) {
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendToServer(pkt);
        }
    }

    public void updateScreen() {
        super.updateScreen();
        TileEntity t = this.tile.getWorld().getTileEntity(this.tile.getX(), this.tile.getY(), this.tile.getZ());
        if (t instanceof TileEnergyUnloader) {
            this.tile = (TileEnergyUnloader)t;
        } else {
            this.mc.thePlayer.closeScreen();
        }
    }
}

