/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiMultiButton;
import mods.railcraft.common.blocks.machine.gamma.TileFluidUnloader;
import mods.railcraft.common.gui.containers.ContainerFluidUnloader;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.InventoryPlayer;

public class GuiUnloaderFluid
extends TileGui {
    private final String FILTER_LABEL = LocalizationPlugin.translate("railcraft.gui.filters");
    private final TileFluidUnloader tile;
    private GuiMultiButton button;

    public GuiUnloaderFluid(InventoryPlayer inv, TileFluidUnloader tile) {
        super(tile, new ContainerFluidUnloader(inv, tile), "railcraft:textures/gui/gui_fluid_loader.png");
        this.tile = tile;
    }

    public void initGui() {
        super.initGui();
        if (this.tile == null) {
            return;
        }
        this.buttonList.clear();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        this.button = new GuiMultiButton(0, w + 40, h + 60, 80, this.tile.getStateController().copy());
        this.buttonList.add(this.button);
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        int sWidth = this.fontRendererObj.getStringWidth(this.tile.getName());
        int sPos = this.xSize / 2 - sWidth / 2;
        this.fontRendererObj.drawString(this.tile.getName(), sPos, 6, 0x404040);
        this.fontRendererObj.drawString(this.FILTER_LABEL, 60, 25, 0x404040);
    }

    public void onGuiClosed() {
        if (Game.isNotHost(this.tile.getWorld())) {
            this.tile.getStateController().setCurrentState(this.button.getController().getCurrentState());
            PacketBuilder.instance().sendGuiReturnPacket(this.tile);
        }
    }
}

