/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import java.util.ArrayList;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiToggleButton;
import mods.railcraft.common.blocks.machine.gamma.TileRFUnloader;
import mods.railcraft.common.gui.containers.ContainerLoaderRF;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.tileentity.TileEntity;

public class GuiUnloaderRF
extends TileGui {
    private final String button1Label = LocalizationPlugin.translate("railcraft.gui.energy.unloader.wait");
    private TileRFUnloader tile;

    public GuiUnloaderRF(TileRFUnloader tile) {
        super(tile, new ContainerLoaderRF(tile), "railcraft:textures/gui/gui_rf_device.png");
        this.tile = tile;
    }

    public void initGui() {
        super.initGui();
        if (this.tile == null) {
            return;
        }
        this.buttonList.clear();
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        ArrayList<GuiToggleButton> buttons = new ArrayList<GuiToggleButton>();
        buttons.add(new GuiToggleButton(0, w + 75, h + 60, 90, this.button1Label, this.tile.waitTillEmpty()));
        GuiTools.newButtonRowBookended(this.buttonList, w + 5, w + this.xSize - 5, buttons);
    }

    protected void actionPerformed(GuiButton guibutton) {
        if (this.tile == null) {
            return;
        }
        if (guibutton.id == 0) {
            this.tile.setWaitTillEmpty(!this.tile.waitTillEmpty());
            ((GuiToggleButton)guibutton).active = this.tile.waitTillEmpty();
        }
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        GuiTools.drawCenteredString(this.fontRendererObj, this.tile.getName(), 6);
    }

    public void onGuiClosed() {
        if (Game.isNotHost(this.tile.getWorld())) {
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendToServer(pkt);
        }
    }

    public void updateScreen() {
        super.updateScreen();
        TileEntity t = this.tile.getWorld().getTileEntity(this.tile.getX(), this.tile.getY(), this.tile.getZ());
        if (t instanceof TileRFUnloader) {
            this.tile = (TileRFUnloader)t;
        } else {
            this.mc.thePlayer.closeScreen();
        }
    }
}

