/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.util.effects.EffectManager;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class EntityChunkLoaderFX
extends EntityFX {
    private final EffectManager.IEffectSource source;

    public EntityChunkLoaderFX(World world, double x, double y, double z, EffectManager.IEffectSource source) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.source = source;
        this.calculateVector();
        this.multipleParticleScaleBy(1.2f);
        float var14 = this.rand.nextFloat() * 0.6f + 0.4f;
        this.particleGreen = this.particleBlue = 1.0f * var14;
        this.particleRed = this.particleBlue;
        this.particleGreen *= 0.3f;
        this.particleRed *= 0.9f;
        this.particleMaxAge = 250;
        this.noClip = true;
        this.setParticleTextureIndex((int)(Math.random() * 8.0));
    }

    private void calculateVector() {
        Vec3 endPoint = Vec3.createVectorHelper((double)this.source.getX(), (double)this.source.getY(), (double)this.source.getZ());
        Vec3 vecParticle = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
        Vec3 vel = vecParticle.subtract(endPoint);
        vel = vel.normalize();
        float velScale = 0.04f;
        this.motionX = vel.xCoord * (double)velScale;
        this.motionY = vel.yCoord * (double)velScale;
        this.motionZ = vel.zCoord * (double)velScale;
    }

    public int getBrightnessForRender(float par1) {
        int var2 = super.getBrightnessForRender(par1);
        float var3 = (float)this.particleAge / (float)this.particleMaxAge;
        var3 *= var3;
        var3 *= var3;
        int var4 = var2 & 0xFF;
        int var5 = var2 >> 16 & 0xFF;
        if ((var5 += (int)(var3 * 15.0f * 16.0f)) > 240) {
            var5 = 240;
        }
        return var4 | var5 << 16;
    }

    public float getBrightness(float par1) {
        float var2 = super.getBrightness(par1);
        float var3 = (float)this.particleAge / (float)this.particleMaxAge;
        var3 = var3 * var3 * var3 * var3;
        return var2 * (1.0f - var3) + var3;
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.source.isDead()) {
            this.setDead();
            return;
        }
        if (!EffectManager.instance.isGoggleAuraActive(ItemGoggles.GoggleAura.ANCHOR)) {
            this.setDead();
            return;
        }
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
            return;
        }
        if (this.getDistanceSq(this.source.getX(), this.source.getY(), this.source.getZ()) <= 0.5) {
            this.setDead();
            return;
        }
        if (this.source instanceof EffectManager.EffectSourceEntity) {
            this.calculateVector();
        }
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
    }
}

