/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class EntityFireSparkFX
extends EntityFX {
    private final float lavaParticleScale;
    private final double endX;
    private final double endY;
    private final double endZ;
    private final double maxDist;

    public EntityFireSparkFX(World world, double x, double y, double z, double endX, double endY, double endZ) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.endX = endX;
        this.endY = endY;
        this.endZ = endZ;
        this.maxDist = this.getDistanceSq(endX, endY, endZ);
        this.calculateVector(this.maxDist);
        this.multipleParticleScaleBy(0.5f);
        this.particleBlue = 1.0f;
        this.particleGreen = 1.0f;
        this.particleRed = 1.0f;
        this.particleScale *= this.rand.nextFloat() * 2.0f + 0.2f;
        this.lavaParticleScale = this.particleScale;
        this.particleMaxAge = 2000;
        this.noClip = true;
        this.setParticleTextureIndex(49);
    }

    private void calculateVector(double dist) {
        Vec3 endPoint = Vec3.createVectorHelper((double)this.endX, (double)this.endY, (double)this.endZ);
        Vec3 vecParticle = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
        Vec3 vel = vecParticle.subtract(endPoint);
        vel = vel.normalize();
        float velScale = 0.1f;
        this.motionX = vel.xCoord * (double)velScale;
        this.motionY = vel.yCoord * (double)velScale + 0.2 * (dist / this.maxDist);
        this.motionZ = vel.zCoord * (double)velScale;
    }

    public int getBrightnessForRender(float par1) {
        int brightness = super.getBrightnessForRender(par1);
        int short1 = 240;
        int j = brightness >> 16 & 0xFF;
        return short1 | j << 16;
    }

    public float getBrightness(float par1) {
        return 1.0f;
    }

    public void renderParticle(Tessellator par1Tessellator, float par2, float par3, float par4, float par5, float par6, float par7) {
        float f6 = ((float)this.particleAge + par2) / (float)this.particleMaxAge;
        this.particleScale = this.lavaParticleScale * (1.0f - f6 * f6);
        super.renderParticle(par1Tessellator, par2, par3, par4, par5, par6, par7);
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
            return;
        }
        double dist = this.getDistanceSq(this.endX, this.endY, this.endZ);
        if (dist <= 0.1) {
            this.setDead();
            return;
        }
        this.calculateVector(dist);
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
    }
}

