/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particles;

import net.minecraft.client.particle.EntityFX;
import net.minecraft.world.World;

public class EntitySimpleParticleFX
extends EntityFX {
    public double gravity = 0.004;

    public EntitySimpleParticleFX(World par1World, double x, double y, double z) {
        this(par1World, x, y, z, 0.0, 0.0, 0.0, 3.0f);
    }

    public EntitySimpleParticleFX(World par1World, double x, double y, double z, double velX, double velY, double velZ, float scale) {
        super(par1World, x, y, z, 0.0, 0.0, 0.0);
        this.motionX *= 0.1;
        this.motionY *= 0.1;
        this.motionZ *= 0.1;
        this.motionX += velX;
        this.motionY += velY;
        this.motionZ += velZ;
        this.particleScale *= 0.75f;
        this.particleScale *= scale;
        this.particleMaxAge = (int)(24.0 / (Math.random() * 0.5 + 0.2));
        this.particleMaxAge = (int)((float)this.particleMaxAge * scale);
        this.noClip = true;
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
        }
        this.setParticleTextureIndex(7 - this.particleAge * 8 / this.particleMaxAge);
        this.motionY += this.gravity;
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        if (this.posY == this.prevPosY) {
            this.motionX *= 1.1;
            this.motionZ *= 1.1;
        }
        this.motionX *= 0.96;
        this.motionY *= 0.96;
        this.motionZ *= 0.96;
        if (this.onGround) {
            this.motionX *= 0.67;
            this.motionZ *= 0.67;
        }
    }
}

