/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mods.railcraft.client.particles.ParticleHelperCallback;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ParticleHelper {
    private static final Random rand = new Random();

    @SideOnly(value=Side.CLIENT)
    public static boolean addHitEffects(World world, Block block, MovingObjectPosition target, EffectRenderer effectRenderer, ParticleHelperCallback callback) {
        int x = target.blockX;
        int y = target.blockY;
        int z = target.blockZ;
        int sideHit = target.sideHit;
        if (block != WorldPlugin.getBlock((IBlockAccess)world, x, y, z)) {
            return true;
        }
        int meta = world.getBlockMetadata(x, y, z);
        float b = 0.1f;
        double px = (double)x + rand.nextDouble() * (block.getBlockBoundsMaxX() - block.getBlockBoundsMinX() - (double)(b * 2.0f)) + (double)b + block.getBlockBoundsMinX();
        double py = (double)y + rand.nextDouble() * (block.getBlockBoundsMaxY() - block.getBlockBoundsMinY() - (double)(b * 2.0f)) + (double)b + block.getBlockBoundsMinY();
        double pz = (double)z + rand.nextDouble() * (block.getBlockBoundsMaxZ() - block.getBlockBoundsMinZ() - (double)(b * 2.0f)) + (double)b + block.getBlockBoundsMinZ();
        if (sideHit == 0) {
            py = (double)y + block.getBlockBoundsMinY() - (double)b;
        }
        if (sideHit == 1) {
            py = (double)y + block.getBlockBoundsMaxY() + (double)b;
        }
        if (sideHit == 2) {
            pz = (double)z + block.getBlockBoundsMinZ() - (double)b;
        }
        if (sideHit == 3) {
            pz = (double)z + block.getBlockBoundsMaxZ() + (double)b;
        }
        if (sideHit == 4) {
            px = (double)x + block.getBlockBoundsMinX() - (double)b;
        }
        if (sideHit == 5) {
            px = (double)x + block.getBlockBoundsMaxX() + (double)b;
        }
        EntityDiggingFX fx = new EntityDiggingFX(world, px, py, pz, 0.0, 0.0, 0.0, block, sideHit, meta);
        fx.setParticleIcon(block.getIcon((IBlockAccess)world, x, y, z, 0));
        if (callback != null) {
            callback.addHitEffects(fx, world, x, y, z, meta);
        }
        effectRenderer.addEffect(fx.applyColourMultiplier(x, y, z).multiplyVelocity(0.2f).multipleParticleScaleBy(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean addDestroyEffects(World world, Block block, int x, int y, int z, int meta, EffectRenderer effectRenderer, ParticleHelperCallback callback) {
        if (block != WorldPlugin.getBlock((IBlockAccess)world, x, y, z)) {
            return true;
        }
        int its = 4;
        for (int i = 0; i < its; ++i) {
            for (int j = 0; j < its; ++j) {
                for (int k = 0; k < its; ++k) {
                    double px = (double)x + ((double)i + 0.5) / (double)its;
                    double py = (double)y + ((double)j + 0.5) / (double)its;
                    double pz = (double)z + ((double)k + 0.5) / (double)its;
                    int random = rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(world, px, py, pz, px - (double)x - 0.5, py - (double)y - 0.5, pz - (double)z - 0.5, block, random, meta);
                    fx.setParticleIcon(block.getIcon((IBlockAccess)world, x, y, z, 0));
                    if (callback != null) {
                        callback.addDestroyEffects(fx, world, x, y, z, meta);
                    }
                    effectRenderer.addEffect((EntityFX)fx.applyColourMultiplier(x, y, z));
                }
            }
        }
        return true;
    }
}

