/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.client.render.BlockRenderer;
import mods.railcraft.client.render.RenderTools;
import mods.railcraft.common.blocks.ore.BlockOre;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderBlockOre
extends BlockRenderer {
    public RenderBlockOre() {
        super(BlockOre.getBlock());
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderblocks) {
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (renderblocks.overrideBlockTexture != null) {
            BlockOre.renderPass = 0;
            RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
        } else {
            BlockOre.renderPass = 0;
            RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
            BlockOre.renderPass = 1;
            RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
        }
        return true;
    }

    @Override
    public void renderItem(RenderBlocks renderBlocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        BlockOre.renderPass = 0;
        this.renderItem(renderBlocks, item, this.getBlock().getIcon(0, item.getItemDamage()));
        BlockOre.renderPass = 1;
        this.renderItem(renderBlocks, item, this.getBlock().getIcon(0, item.getItemDamage()));
        GL11.glPopAttrib();
    }

    private void renderItem(RenderBlocks renderBlocks, ItemStack item, IIcon texture) {
        if (texture == null) {
            return;
        }
        int meta = item.getItemDamage();
        Block block = this.getBlock();
        block.setBlockBoundsForItemRender();
        renderBlocks.setRenderBoundsFromBlock(block);
        if (renderBlocks.useInventoryTint) {
            int color = block.getRenderColor(meta);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        }
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Tessellator tess = Tessellator.instance;
        tess.startDrawingQuads();
        tess.setNormal(0.0f, -1.0f, 0.0f);
        renderBlocks.renderFaceYNeg(block, 0.0, 0.0, 0.0, texture);
        tess.draw();
        tess.startDrawingQuads();
        tess.setNormal(0.0f, 1.0f, 0.0f);
        renderBlocks.renderFaceYPos(block, 0.0, 0.0, 0.0, texture);
        tess.draw();
        tess.startDrawingQuads();
        tess.setNormal(0.0f, 0.0f, -1.0f);
        renderBlocks.renderFaceZNeg(block, 0.0, 0.0, 0.0, texture);
        tess.draw();
        tess.startDrawingQuads();
        tess.setNormal(0.0f, 0.0f, 1.0f);
        renderBlocks.renderFaceZPos(block, 0.0, 0.0, 0.0, texture);
        tess.draw();
        tess.startDrawingQuads();
        tess.setNormal(-1.0f, 0.0f, 0.0f);
        renderBlocks.renderFaceXNeg(block, 0.0, 0.0, 0.0, texture);
        tess.draw();
        tess.startDrawingQuads();
        tess.setNormal(1.0f, 0.0f, 0.0f);
        renderBlocks.renderFaceXPos(block, 0.0, 0.0, 0.0, texture);
        tess.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

