/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import java.util.Arrays;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderFakeBlock {
    private static RenderBlocks renderBlocks = new RenderBlocks();

    public static void renderBlockForEntity(RenderInfo info, IBlockAccess blockAccess, int i, int j, int k, boolean doLight, boolean doTessellating) {
        RenderFakeBlock.renderBlock(info, blockAccess, -0.5, -0.5, -0.5, i, j, k, doLight, doTessellating);
    }

    public static void renderAsBlock(RenderInfo info, RenderBlocks renderBlocks, IBlockAccess blockAccess, double x, double y, double z) {
        BlockCube block = BlockCube.getBlock();
        if (block != null) {
            block.setTextureOverride(info);
            renderBlocks.setRenderBounds((double)info.minX, (double)info.minY, (double)info.minZ, (double)info.maxX, (double)info.maxY, (double)info.maxZ);
            renderBlocks.renderStandardBlock((Block)block, (int)x, (int)y, (int)z);
            block.setTextureOverride(null);
        } else {
            RenderFakeBlock.renderBlock(info, blockAccess, x, y, z, true, false);
        }
    }

    public static void renderBlock(RenderInfo info, IBlockAccess blockAccess, double x, double y, double z, boolean doLight, boolean doTessellating) {
        RenderFakeBlock.renderBlock(info, blockAccess, x, y, z, (int)x, (int)y, (int)z, doLight, doTessellating);
    }

    public static void renderBlock(RenderInfo info, IBlockAccess blockAccess, double x, double y, double z, int lightX, int lightY, int lightZ, boolean doLight, boolean doTessellating) {
        float lightBottom = 0.5f;
        float lightTop = 1.0f;
        float lightEastWest = 0.8f;
        float lightNorthSouth = 0.6f;
        Tessellator tessellator = Tessellator.instance;
        if (blockAccess == null) {
            doLight = false;
        }
        if (doTessellating) {
            tessellator.startDrawingQuads();
        }
        float light = 0.0f;
        if (doLight) {
            light = info.light < 0.0f ? 1.0f : info.light;
            int brightness = 0;
            brightness = info.brightness < 0 ? info.template.getMixedBrightnessForBlock(blockAccess, lightX, lightY, lightZ) : info.brightness;
            tessellator.setBrightness(brightness);
            tessellator.setColorOpaque_F(lightBottom * light, lightBottom * light, lightBottom * light);
        } else if (info.brightness >= 0) {
            tessellator.setBrightness(info.brightness);
        }
        renderBlocks.setRenderBounds((double)info.minX, (double)info.minY, (double)info.minZ, (double)info.maxX, (double)info.maxY, (double)info.maxZ);
        if (info.renderSide[0]) {
            renderBlocks.renderFaceYNeg(info.template, x, y, z, info.getBlockTextureFromSide(0));
        }
        if (doLight) {
            tessellator.setColorOpaque_F(lightTop * light, lightTop * light, lightTop * light);
        }
        if (info.renderSide[1]) {
            renderBlocks.renderFaceYPos(info.template, x, y, z, info.getBlockTextureFromSide(1));
        }
        if (doLight) {
            tessellator.setColorOpaque_F(lightEastWest * light, lightEastWest * light, lightEastWest * light);
        }
        if (info.renderSide[2]) {
            renderBlocks.renderFaceZNeg(info.template, x, y, z, info.getBlockTextureFromSide(2));
        }
        if (doLight) {
            tessellator.setColorOpaque_F(lightEastWest * light, lightEastWest * light, lightEastWest * light);
        }
        if (info.renderSide[3]) {
            renderBlocks.renderFaceZPos(info.template, x, y, z, info.getBlockTextureFromSide(3));
        }
        if (doLight) {
            tessellator.setColorOpaque_F(lightNorthSouth * light, lightNorthSouth * light, lightNorthSouth * light);
        }
        if (info.renderSide[4]) {
            renderBlocks.renderFaceXNeg(info.template, x, y, z, info.getBlockTextureFromSide(4));
        }
        if (doLight) {
            tessellator.setColorOpaque_F(lightNorthSouth * light, lightNorthSouth * light, lightNorthSouth * light);
        }
        if (info.renderSide[5]) {
            renderBlocks.renderFaceXPos(info.template, x, y, z, info.getBlockTextureFromSide(5));
        }
        if (doTessellating) {
            tessellator.draw();
        }
    }

    public static void renderBlockOnInventory(RenderBlocks renderblocks, RenderInfo info, float light) {
        RenderFakeBlock.renderBlockOnInventory(renderblocks, info, light, -1);
    }

    public static void renderBlockOnInventory(RenderBlocks renderer, RenderInfo info, float light, int side) {
        if (side >= 0) {
            info.setRenderSingleSide(side);
        }
        Block block = info.template;
        Tessellator tessellator = Tessellator.instance;
        if (renderer.useInventoryTint) {
            int j = block.getRenderColor(9);
            float red = (float)(j >> 16 & 0xFF) / 255.0f;
            float green = (float)(j >> 8 & 0xFF) / 255.0f;
            float blue = (float)(j & 0xFF) / 255.0f;
            GL11.glColor4f((float)(red * light), (float)(green * light), (float)(blue * light), (float)1.0f);
        }
        renderer.setRenderBounds((double)info.minX, (double)info.minY, (double)info.minZ, (double)info.maxX, (double)info.maxY, (double)info.maxZ);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        int s = 0;
        if (info.renderSide[s]) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            IIcon icon = info.getBlockTextureFromSide(s);
            if (icon != null) {
                renderer.renderFaceYNeg(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.draw();
        }
        if (info.renderSide[s = 1]) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            IIcon icon = info.getBlockTextureFromSide(s);
            if (icon != null) {
                renderer.renderFaceYPos(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.draw();
        }
        if (info.renderSide[s = 2]) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            IIcon icon = info.getBlockTextureFromSide(s);
            if (icon != null) {
                renderer.renderFaceZNeg(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.draw();
        }
        if (info.renderSide[s = 3]) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            IIcon icon = info.getBlockTextureFromSide(s);
            if (icon != null) {
                renderer.renderFaceZPos(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.draw();
        }
        if (info.renderSide[s = 4]) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            IIcon icon = info.getBlockTextureFromSide(s);
            if (icon != null) {
                renderer.renderFaceXNeg(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.draw();
        }
        if (info.renderSide[s = 5]) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            IIcon icon = info.getBlockTextureFromSide(s);
            if (icon != null) {
                renderer.renderFaceXPos(block, 0.0, 0.0, 0.0, icon);
            }
            tessellator.draw();
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        if (side >= 0) {
            info.setRenderAllSides();
        }
    }

    public static class RenderInfo {
        public Block template = Blocks.stone;
        public IIcon[] texture = null;
        public IIcon override = null;
        public float minX = 0.0f;
        public float minY = 0.0f;
        public float minZ = 0.0f;
        public float maxX = 1.0f;
        public float maxY = 1.0f;
        public float maxZ = 1.0f;
        public boolean[] renderSide = new boolean[6];
        public float light = -1.0f;
        public int brightness = -1;

        public RenderInfo() {
            this.setRenderAllSides();
        }

        public RenderInfo(Block template, IIcon[] texture) {
            this();
            this.template = template;
            this.texture = texture;
        }

        public RenderInfo(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            this();
            this.setBlockBounds(minX, minY, minZ, maxX, maxY, maxZ);
        }

        public final void setBlockBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        public final void setRenderSingleSide(int side) {
            Arrays.fill(this.renderSide, false);
            this.renderSide[side] = true;
        }

        public final void setRenderAllSides() {
            Arrays.fill(this.renderSide, true);
        }

        public void rotate() {
            float temp = this.minX;
            this.minX = this.minZ;
            this.minZ = temp;
            temp = this.maxX;
            this.maxX = this.maxZ;
            this.maxZ = temp;
        }

        public void reverseX() {
            float temp = this.minX;
            this.minX = 1.0f - this.maxX;
            this.maxX = 1.0f - temp;
        }

        public void reverseZ() {
            float temp = this.minZ;
            this.minZ = 1.0f - this.maxZ;
            this.maxZ = 1.0f - temp;
        }

        public IIcon getBlockTextureFromSide(int i) {
            if (this.override != null) {
                return this.override;
            }
            if (this.texture == null || this.texture.length == 0) {
                return this.template.getBlockTextureFromSide(i);
            }
            if (i >= this.texture.length) {
                i = 0;
            }
            return this.texture[i];
        }
    }
}

