/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.client.render.ICombinedRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.render.RenderTESRSignals;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.aesthetics.post.PostConnectionHelper;
import mods.railcraft.common.blocks.signals.BlockSignalRailcraft;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.IDualHeadSignal;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderSignalDual
extends RenderTESRSignals
implements ICombinedRenderer {
    private RenderFakeBlock.RenderInfo info = new RenderFakeBlock.RenderInfo();
    private static final RenderFakeBlock.RenderInfo tesrInfo = new RenderFakeBlock.RenderInfo();

    public RenderSignalDual() {
        this.info.texture = new IIcon[6];
        this.info.template = RailcraftBlocks.getBlockSignal();
        RenderSignalDual.tesrInfo.texture = new IIcon[6];
        RenderSignalDual.tesrInfo.template = RailcraftBlocks.getBlockSignal();
    }

    @Override
    public void renderBlock(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, Block block) {
        boolean south;
        int ii;
        float temp;
        IDualHeadSignal tile = (IDualHeadSignal)world.getTileEntity(x, y, z);
        int facing = tile.getFacing().ordinal();
        if (facing >= this.info.texture.length) {
            facing = 0;
        }
        float pix = 0.0625f;
        float f = 3.0f * pix;
        float f1 = 13.0f * pix;
        this.info.setBlockBounds(f, 0.0f, f, f1, 1.0f, f1);
        this.info.texture[0] = BlockSignalRailcraft.texturesSignalDual[0];
        this.info.texture[1] = BlockSignalRailcraft.texturesSignalDual[0];
        this.info.texture[2] = BlockSignalRailcraft.texturesSignalDual[1];
        this.info.texture[3] = BlockSignalRailcraft.texturesSignalDual[1];
        this.info.texture[4] = BlockSignalRailcraft.texturesSignalDual[1];
        this.info.texture[5] = BlockSignalRailcraft.texturesSignalDual[1];
        this.info.texture[facing] = BlockSignalRailcraft.texturesSignalDual[2];
        RenderFakeBlock.renderBlock(this.info, world, x, y, z, true, false);
        this.info.brightness = -1;
        this.info.setRenderAllSides();
        this.info.texture[facing] = BlockSignalRailcraft.texturesSignalDual[2];
        if (facing == 2 || facing == 3) {
            temp = 13.0f * pix;
            if (facing == 2) {
                temp = pix;
            }
            for (ii = 0; ii < 2; ++ii) {
                this.info.setBlockBounds(6.0f * pix, 7.0f * pix + (float)ii * 6.0f * pix, temp, 10.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, temp + 2.0f * pix);
                RenderFakeBlock.renderBlock(this.info, world, x, y, z, true, false);
                this.info.setBlockBounds(5.0f * pix, 4.0f * pix + (float)ii * 6.0f * pix, temp, 6.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, temp + 2.0f * pix);
                RenderFakeBlock.renderBlock(this.info, world, x, y, z, true, false);
                this.info.setBlockBounds(10.0f * pix, 4.0f * pix + (float)ii * 6.0f * pix, temp, 11.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, temp + 2.0f * pix);
                RenderFakeBlock.renderBlock(this.info, world, x, y, z, true, false);
            }
        } else if (facing == 4 || facing == 5) {
            temp = 13.0f * pix;
            if (facing == 4) {
                temp = pix;
            }
            for (ii = 0; ii < 2; ++ii) {
                this.info.setBlockBounds(temp, 7.0f * pix + (float)ii * 6.0f * pix, 6.0f * pix, temp + 2.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, 10.0f * pix);
                RenderFakeBlock.renderBlock(this.info, world, x, y, z, true, false);
                this.info.setBlockBounds(temp, 4.0f * pix + (float)ii * 6.0f * pix, 5.0f * pix, temp + 2.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, 6.0f * pix);
                RenderFakeBlock.renderBlock(this.info, world, x, y, z, true, false);
                this.info.setBlockBounds(temp, 4.0f * pix + (float)ii * 6.0f * pix, 10.0f * pix, temp + 2.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, 11.0f * pix);
                RenderFakeBlock.renderBlock(this.info, world, x, y, z, true, false);
            }
        }
        boolean east_west = false;
        boolean north_south = false;
        boolean west = PostConnectionHelper.connect(world, x, y, z, ForgeDirection.WEST) != IPostConnection.ConnectStyle.NONE;
        boolean east = PostConnectionHelper.connect(world, x, y, z, ForgeDirection.EAST) != IPostConnection.ConnectStyle.NONE;
        boolean north = PostConnectionHelper.connect(world, x, y, z, ForgeDirection.NORTH) != IPostConnection.ConnectStyle.NONE;
        boolean bl = south = PostConnectionHelper.connect(world, x, y, z, ForgeDirection.SOUTH) != IPostConnection.ConnectStyle.NONE;
        if (east || west) {
            east_west = true;
        }
        if (north || south) {
            north_south = true;
        }
        if (!east_west && !north_south) {
            east_west = true;
        }
        f = 0.4375f;
        f1 = 0.5625f;
        float f2 = 11.0f * pix;
        float f3 = 14.0f * pix;
        float f4 = west ? 0.0f : f;
        float f5 = east ? 1.0f : f1;
        float f6 = north ? 0.0f : f;
        float f7 = south ? 1.0f : f1;
        this.info.texture[0] = BlockSignalRailcraft.texturesSignalDual[3];
        this.info.texture[1] = BlockSignalRailcraft.texturesSignalDual[3];
        this.info.texture[2] = BlockSignalRailcraft.texturesSignalDual[4];
        this.info.texture[3] = BlockSignalRailcraft.texturesSignalDual[4];
        this.info.texture[4] = BlockSignalRailcraft.texturesSignalDual[4];
        this.info.texture[5] = BlockSignalRailcraft.texturesSignalDual[4];
        if (east_west) {
            this.info.setBlockBounds(f4, f2, f, f5, f3, f1);
            RenderFakeBlock.renderBlock(this.info, world, x, y, z, true, false);
        }
        if (north_south) {
            this.info.setBlockBounds(f, f2, f6, f1, f3, f7);
            RenderFakeBlock.renderBlock(this.info, world, x, y, z, true, false);
        }
        f2 = 5.0f * pix;
        f3 = 8.0f * pix;
        if (east_west) {
            this.info.setBlockBounds(f4, f2, f, f5, f3, f1);
            RenderFakeBlock.renderBlock(this.info, world, x, y, z, true, false);
        }
        if (north_south) {
            this.info.setBlockBounds(f, f2, f6, f1, f3, f7);
            RenderFakeBlock.renderBlock(this.info, world, x, y, z, true, false);
        }
    }

    @Override
    public void renderItem(RenderBlocks renderblocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
        EnumSignal signalType = EnumSignal.fromId(item.getItemDamage());
        float pix = 0.0625f;
        float f = 3.0f * pix;
        float f1 = 13.0f * pix;
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        this.info.setBlockBounds(f, 0.0f, f, f1, 1.0f, f1);
        this.info.texture[0] = BlockSignalRailcraft.texturesSignalDual[0];
        this.info.texture[1] = BlockSignalRailcraft.texturesSignalDual[0];
        this.info.texture[2] = BlockSignalRailcraft.texturesSignalDual[1];
        this.info.texture[3] = BlockSignalRailcraft.texturesSignalDual[2];
        this.info.texture[4] = BlockSignalRailcraft.texturesSignalDual[1];
        this.info.texture[5] = BlockSignalRailcraft.texturesSignalDual[1];
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.texture[3] = BlockSignalRailcraft.texturesLampTop[signalType == EnumSignal.DUAL_HEAD_BLOCK_SIGNAL ? 0 : 2];
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f, 3);
        this.info.texture[3] = BlockSignalRailcraft.texturesLampBottom[signalType == EnumSignal.DUAL_HEAD_BLOCK_SIGNAL ? 2 : 0];
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f, 3);
        this.info.texture[3] = BlockSignalRailcraft.texturesSignalDual[2];
        float temp = 13.0f * pix;
        for (int ii = 0; ii < 2; ++ii) {
            this.info.setBlockBounds(6.0f * pix, 7.0f * pix + (float)ii * 6.0f * pix, temp, 10.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, temp + 2.0f * pix);
            RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
            this.info.setBlockBounds(5.0f * pix, 4.0f * pix + (float)ii * 6.0f * pix, temp, 6.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, temp + 2.0f * pix);
            RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
            this.info.setBlockBounds(10.0f * pix, 4.0f * pix + (float)ii * 6.0f * pix, temp, 11.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, temp + 2.0f * pix);
            RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        }
        GL11.glPopAttrib();
    }

    @Override
    public void renderTileEntityAt(TileEntity te, double x, double y, double z, float f) {
        super.renderTileEntityAt(te, x, y, z, f);
        if (!(te instanceof IDualHeadSignal)) {
            return;
        }
        RenderFakeBlock.RenderInfo info = tesrInfo;
        IDualHeadSignal tile = (IDualHeadSignal)te;
        int facing = tile.getFacing().ordinal();
        if (facing >= info.texture.length) {
            facing = 0;
        }
        info.setRenderSingleSide(facing);
        SignalAspect aspect = tile.getTopAspect();
        if (!aspect.isLit()) {
            aspect = SignalAspect.OFF;
        }
        info.texture[facing] = BlockSignalRailcraft.texturesLampTop[aspect.getTextureIndex()];
        info.brightness = aspect.getTextureBrightness();
        RenderSignalDual.doRenderAspect(info, te, x, y, z);
        aspect = tile.getBottomAspect();
        if (!aspect.isLit()) {
            aspect = SignalAspect.OFF;
        }
        info.texture[facing] = BlockSignalRailcraft.texturesLampBottom[aspect.getTextureIndex()];
        info.brightness = aspect.getTextureBrightness();
        RenderSignalDual.doRenderAspect(info, te, x, y, z);
    }
}

