/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import java.util.Arrays;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.AbstractPair;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.ISignalBlockTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.render.RenderTools;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderTESRSignals
extends TileEntitySpecialRenderer {
    public void renderTileEntityAt(TileEntity tile, double x, double y, double z, float f) {
        EntityLivingBase player;
        String name;
        if (tile instanceof IControllerTile) {
            if (EffectManager.instance.isGoggleAuraActive(ItemGoggles.GoggleAura.TUNING)) {
                this.renderPairs(tile, x, y, z, f, ((IControllerTile)tile).getController(), ColorProfile.RAINBOW);
            } else if (EffectManager.instance.isGoggleAuraActive(ItemGoggles.GoggleAura.SIGNALLING)) {
                this.renderPairs(tile, x, y, z, f, ((IControllerTile)tile).getController(), ColorProfile.ASPECT);
            }
        }
        if (tile instanceof ISignalBlockTile) {
            if (EffectManager.instance.isGoggleAuraActive(ItemGoggles.GoggleAura.SURVEYING)) {
                this.renderPairs(tile, x, y, z, f, ((ISignalBlockTile)tile).getSignalBlock(), ColorProfile.RAINBOW);
            } else if (EffectManager.instance.isGoggleAuraActive(ItemGoggles.GoggleAura.SIGNALLING)) {
                this.renderPairs(tile, x, y, z, f, ((ISignalBlockTile)tile).getSignalBlock(), ColorProfile.BLUE);
            }
        }
        AbstractPair pair = null;
        if (tile instanceof IReceiverTile) {
            pair = ((IReceiverTile)tile).getReceiver();
        } else if (tile instanceof IControllerTile) {
            pair = ((IControllerTile)tile).getController();
        } else if (tile instanceof ISignalBlockTile) {
            pair = ((ISignalBlockTile)tile).getSignalBlock();
        }
        if (pair != null && (name = pair.getName()) != null && (player = RenderManager.instance.livingPlayer) != null) {
            MovingObjectPosition mop;
            float viewDist = 8.0f;
            double dist = player.getDistanceSq((double)tile.xCoord + 0.5, (double)tile.yCoord + 0.5, (double)tile.zCoord + 0.5);
            if (dist <= 64.0 && (mop = player.rayTrace(8.0, f)) != null && mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && player.worldObj.getTileEntity(mop.blockX, mop.blockY, mop.blockZ) == tile) {
                RenderTools.renderString(name, x + 0.5, y + 1.5, z + 0.5);
            }
        }
    }

    private void renderPairs(TileEntity tile, double x, double y, double z, float f, AbstractPair pair, ColorProfile colorProfile) {
        if (pair.getPairs().isEmpty()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        GL11.glLineWidth((float)5.0f);
        GL11.glBegin((int)1);
        for (WorldCoordinate target : pair.getPairs()) {
            int color = colorProfile.getColor(tile, pair.getCoords(), target);
            float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
            float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float c3 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor3f((float)c1, (float)c2, (float)c3);
            GL11.glVertex3f((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            float tx = (float)x + (float)target.x - (float)tile.xCoord;
            float ty = (float)y + (float)target.y - (float)tile.yCoord;
            float tz = (float)z + (float)target.z - (float)tile.zCoord;
            GL11.glVertex3f((float)(tx + 0.5f), (float)(ty + 0.5f), (float)(tz + 0.5f));
        }
        GL11.glEnd();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    protected static void doRenderAspect(RenderFakeBlock.RenderInfo info, TileEntity tile, double x, double y, double z) {
        Tessellator tessellator = Tessellator.instance;
        float depth = 0.125f;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        Minecraft.getMinecraft().getTextureManager().bindTexture(TextureMap.locationBlocksTexture);
        tessellator.startDrawingQuads();
        if (info.brightness < 0) {
            float lightBottom = 0.5f;
            float light = info.light < 0.0f ? 1.0f : info.light;
            int br = info.brightness < 0 ? info.template.getMixedBrightnessForBlock((IBlockAccess)tile.getWorldObj(), tile.xCoord, tile.yCoord, tile.zCoord) : info.brightness;
            tessellator.setBrightness(br);
            tessellator.setColorOpaque_F(lightBottom * light, lightBottom * light, lightBottom * light);
        } else {
            tessellator.setBrightness(info.brightness);
        }
        if (info.renderSide[2]) {
            tessellator.addVertexWithUV(0.0, 0.0, 0.125, (double)info.texture[2].getInterpolatedU(16.0), (double)info.texture[2].getInterpolatedV(16.0));
            tessellator.addVertexWithUV(0.0, 1.0, 0.125, (double)info.texture[2].getInterpolatedU(16.0), (double)info.texture[2].getInterpolatedV(0.0));
            tessellator.addVertexWithUV(1.0, 1.0, 0.125, (double)info.texture[2].getInterpolatedU(0.0), (double)info.texture[2].getInterpolatedV(0.0));
            tessellator.addVertexWithUV(1.0, 0.0, 0.125, (double)info.texture[2].getInterpolatedU(0.0), (double)info.texture[2].getInterpolatedV(16.0));
        }
        if (info.renderSide[3]) {
            tessellator.addVertexWithUV(0.0, 0.0, 0.875, (double)info.texture[3].getInterpolatedU(0.0), (double)info.texture[3].getInterpolatedV(16.0));
            tessellator.addVertexWithUV(1.0, 0.0, 0.875, (double)info.texture[3].getInterpolatedU(16.0), (double)info.texture[3].getInterpolatedV(16.0));
            tessellator.addVertexWithUV(1.0, 1.0, 0.875, (double)info.texture[3].getInterpolatedU(16.0), (double)info.texture[3].getInterpolatedV(0.0));
            tessellator.addVertexWithUV(0.0, 1.0, 0.875, (double)info.texture[3].getInterpolatedU(0.0), (double)info.texture[3].getInterpolatedV(0.0));
        }
        if (info.renderSide[4]) {
            tessellator.addVertexWithUV(0.125, 0.0, 0.0, (double)info.texture[4].getInterpolatedU(0.0), (double)info.texture[4].getInterpolatedV(16.0));
            tessellator.addVertexWithUV(0.125, 0.0, 1.0, (double)info.texture[4].getInterpolatedU(16.0), (double)info.texture[4].getInterpolatedV(16.0));
            tessellator.addVertexWithUV(0.125, 1.0, 1.0, (double)info.texture[4].getInterpolatedU(16.0), (double)info.texture[4].getInterpolatedV(0.0));
            tessellator.addVertexWithUV(0.125, 1.0, 0.0, (double)info.texture[4].getInterpolatedU(0.0), (double)info.texture[4].getInterpolatedV(0.0));
        }
        if (info.renderSide[5]) {
            tessellator.addVertexWithUV(0.875, 0.0, 0.0, (double)info.texture[5].getInterpolatedU(16.0), (double)info.texture[5].getInterpolatedV(16.0));
            tessellator.addVertexWithUV(0.875, 1.0, 0.0, (double)info.texture[5].getInterpolatedU(16.0), (double)info.texture[5].getInterpolatedV(0.0));
            tessellator.addVertexWithUV(0.875, 1.0, 1.0, (double)info.texture[5].getInterpolatedU(0.0), (double)info.texture[5].getInterpolatedV(0.0));
            tessellator.addVertexWithUV(0.875, 0.0, 1.0, (double)info.texture[5].getInterpolatedU(0.0), (double)info.texture[5].getInterpolatedV(16.0));
        }
        tessellator.draw();
        GL11.glPopMatrix();
    }

    public static enum ColorProfile {
        RAINBOW{
            private final WorldCoordinate[] coords = new WorldCoordinate[2];
            private final boolean apiUpdated = Comparable.class.isAssignableFrom(WorldCoordinate.class);

            @Override
            public int getColor(TileEntity tile, WorldCoordinate source, WorldCoordinate target) {
                this.coords[0] = source;
                this.coords[1] = target;
                if (this.apiUpdated) {
                    Arrays.sort(this.coords);
                }
                return Arrays.hashCode(this.coords);
            }
        }
        ,
        BLUE{

            @Override
            public int getColor(TileEntity tile, WorldCoordinate source, WorldCoordinate target) {
                return EnumColor.BLUE.getHexColor();
            }
        }
        ,
        ASPECT{

            @Override
            public int getColor(TileEntity tile, WorldCoordinate source, WorldCoordinate target) {
                if (tile instanceof IControllerTile) {
                    SignalAspect aspect = ((IControllerTile)tile).getController().getAspectFor(target);
                    switch (aspect) {
                        case GREEN: {
                            return EnumColor.LIME.getHexColor();
                        }
                        case YELLOW: 
                        case BLINK_YELLOW: {
                            return EnumColor.YELLOW.getHexColor();
                        }
                    }
                    return EnumColor.RED.getHexColor();
                }
                return BLUE.getColor(tile, source, target);
            }
        };


        public abstract int getColor(TileEntity var1, WorldCoordinate var2, WorldCoordinate var3);
    }
}

