/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render.carts;

import mods.railcraft.client.render.FluidRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.render.carts.CartContentRenderer;
import mods.railcraft.client.render.carts.RenderCart;
import mods.railcraft.common.carts.EntityCartTank;
import mods.railcraft.common.fluids.tanks.StandardTank;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class CartContentRendererTank
extends CartContentRenderer {
    private final RenderFakeBlock.RenderInfo fillBlock = new RenderFakeBlock.RenderInfo(0.4f, 0.0f, 0.4f, 0.6f, 0.999f, 0.6f);

    public CartContentRendererTank() {
        this.fillBlock.texture = new IIcon[6];
    }

    private void renderTank(RenderCart renderer, EntityMinecart cart, float light, float time, int x, int y, int z) {
        int[] displayLists;
        EntityCartTank cartTank = (EntityCartTank)cart;
        StandardTank tank = cartTank.getTankManager().get(0);
        if (tank.renderData.fluid != null && tank.renderData.amount > 0 && (displayLists = FluidRenderer.getLiquidDisplayLists(tank.renderData.fluid)) != null) {
            ResourceLocation texSheet;
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0625f, (float)0.0f);
            float cap = tank.getCapacity();
            float level = Math.min((float)tank.renderData.amount, cap) / cap;
            renderer.bindTex(FluidRenderer.getFluidSheet(tank.renderData.fluid));
            FluidRenderer.setColorForTank(tank);
            GL11.glCallList((int)displayLists[(int)(level * 99.0f)]);
            if (cartTank.isFilling() && (texSheet = FluidRenderer.setupFlowingLiquidTexture(tank.renderData.fluid, this.fillBlock.texture)) != null) {
                renderer.bindTex(texSheet);
                RenderFakeBlock.renderBlockForEntity(this.fillBlock, (IBlockAccess)cart.worldObj, x, y, z, false, true);
            }
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    private void renderFilterItem(RenderCart renderer, EntityCartTank cart, float light, float time, int x, int y, int z) {
        if (!cart.hasFilter()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        EntityItem item = new EntityItem(null, 0.0, 0.0, 0.0, cart.getFilterItem().copy());
        item.getEntityItem().stackSize = 1;
        item.hoverStart = 0.0f;
        float scale = 1.2f;
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-0.6f, (float)0.68f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.renderItem(item);
        GL11.glPopMatrix();
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-0.6f, (float)0.68f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.renderItem(item);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void renderItem(EntityItem item) {
        RenderItem.renderInFrame = true;
        RenderManager.instance.renderEntityWithPosYaw((Entity)item, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        if (!RenderManager.instance.options.fancyGraphics) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderManager.instance.renderEntityWithPosYaw((Entity)item, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        RenderItem.renderInFrame = false;
    }

    @Override
    public void render(RenderCart renderer, EntityMinecart cart, float light, float time) {
        super.render(renderer, cart, light, time);
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
        int x = (int)Math.floor(cart.posX);
        int y = (int)Math.floor(cart.posY);
        int z = (int)Math.floor(cart.posZ);
        this.renderTank(renderer, cart, light, time, x, y, z);
        EntityCartTank cartTank = (EntityCartTank)cart;
        this.renderFilterItem(renderer, cartTank, light, time, x, y, z);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

