/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render.carts;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mods.railcraft.api.carts.IRoutableCart;
import mods.railcraft.api.carts.locomotive.IRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.render.carts.CartContentRenderer;
import mods.railcraft.client.render.carts.CartContentRendererCargo;
import mods.railcraft.client.render.carts.CartContentRendererMaintance;
import mods.railcraft.client.render.carts.CartContentRendererRedstoneFlux;
import mods.railcraft.client.render.carts.CartContentRendererTNT;
import mods.railcraft.client.render.carts.CartContentRendererTank;
import mods.railcraft.client.render.carts.CartModelRenderer;
import mods.railcraft.client.render.carts.LocomotiveRenderer;
import mods.railcraft.common.carts.CartExplosiveBase;
import mods.railcraft.common.carts.CartMaintenanceBase;
import mods.railcraft.common.carts.EntityCartCargo;
import mods.railcraft.common.carts.EntityCartRF;
import mods.railcraft.common.carts.EntityCartTank;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.IDirectionalCart;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class RenderCart
extends Render
implements IRenderer {
    private final Random rand = new Random();
    private final RenderFakeBlock.RenderInfo fakeBlock = new RenderFakeBlock.RenderInfo();
    private static final Map<Class, CartModelRenderer> renderersCore = new HashMap<Class, CartModelRenderer>();
    private static final Map<Class, CartContentRenderer> renderersContent = new HashMap<Class, CartContentRenderer>();
    private static final CartModelRenderer defaultCoreRenderer = new CartModelRenderer();
    private static final CartContentRenderer defaultContentRenderer = new CartContentRenderer();

    public RenderCart() {
        this.shadowSize = 0.5f;
        this.fakeBlock.texture = new IIcon[6];
        renderersCore.put(EntityLocomotive.class, LocomotiveRenderer.INSTANCE);
        renderersContent.put(EntityCartCargo.class, new CartContentRendererCargo());
        renderersContent.put(EntityCartTank.class, new CartContentRendererTank());
        renderersContent.put(EntityCartRF.class, CartContentRendererRedstoneFlux.instance());
        renderersContent.put(CartExplosiveBase.class, new CartContentRendererTNT());
        renderersContent.put(CartMaintenanceBase.class, new CartContentRendererMaintance());
    }

    public void renderCart(EntityMinecart cart, double x, double y, double z, float yaw, float time) {
        float light;
        boolean renderContents;
        String dest;
        GL11.glPushMatrix();
        long var10 = (long)cart.getEntityId() * 493286711L;
        var10 = var10 * var10 * 4392167121L + var10 * 98761L;
        float tx = (((float)(var10 >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float ty = (((float)(var10 >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float tz = (((float)(var10 >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        GL11.glTranslatef((float)tx, (float)ty, (float)tz);
        double mx = cart.lastTickPosX + (cart.posX - cart.lastTickPosX) * (double)time;
        double my = cart.lastTickPosY + (cart.posY - cart.lastTickPosY) * (double)time;
        double mz = cart.lastTickPosZ + (cart.posZ - cart.lastTickPosZ) * (double)time;
        double d6 = 0.3;
        Vec3 vec3d = cart.func_70489_a(mx, my, mz);
        float pitch = cart.prevRotationPitch + (cart.rotationPitch - cart.prevRotationPitch) * time;
        if (vec3d != null) {
            Vec3 vec3d1 = cart.func_70495_a(mx, my, mz, d6);
            Vec3 vec3d2 = cart.func_70495_a(mx, my, mz, -d6);
            if (vec3d1 == null) {
                vec3d1 = vec3d;
            }
            if (vec3d2 == null) {
                vec3d2 = vec3d;
            }
            x += vec3d.xCoord - mx;
            y += (vec3d1.yCoord + vec3d2.yCoord) / 2.0 - my;
            z += vec3d.zCoord - mz;
            Vec3 vec3d3 = vec3d2.addVector(-vec3d1.xCoord, -vec3d1.yCoord, -vec3d1.zCoord);
            if (vec3d3.lengthVector() != 0.0) {
                vec3d3 = vec3d3.normalize();
                yaw = (float)(Math.atan2(vec3d3.zCoord, vec3d3.xCoord) / Math.PI) * 180.0f;
                pitch = (float)(Math.atan(vec3d3.yCoord) * 73.0);
            }
        }
        if (cart instanceof IDirectionalCart) {
            if ((yaw %= 360.0f) < 0.0f) {
                yaw += 360.0f;
            }
            yaw += 360.0f;
            double serverYaw = cart.rotationYaw;
            serverYaw += 180.0;
            if ((serverYaw %= 360.0) < 0.0) {
                serverYaw += 360.0;
            }
            if (Math.abs((double)yaw - (serverYaw += 360.0)) > 90.0) {
                yaw += 180.0f;
                pitch = -pitch;
            }
            ((IDirectionalCart)cart).setRenderYaw(yaw);
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        boolean name = false;
        if (cart.hasCustomInventoryName()) {
            this.renderHaloText((Entity)cart, cart.getCommandSenderName(), 0.0, 0.0, 0.0, 64);
            name = true;
        }
        if (cart instanceof IRoutableCart && !(dest = ((IRoutableCart)cart).getDestination()).isEmpty()) {
            this.renderHaloText((Entity)cart, dest, 0.0, name ? 0.5 : 0.0, 0.0, 64);
        }
        GL11.glRotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-pitch), (float)0.0f, (float)0.0f, (float)1.0f);
        float f3 = (float)cart.getRollingAmplitude() - time;
        float f4 = cart.getDamage() - time;
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f3 > 0.0f) {
            float angle = MathHelper.sin((float)f3) * f3 * f4 / 10.0f;
            angle = Math.min(angle, 0.8f);
            angle = Math.copySign(angle, cart.getRollingDirection());
            GL11.glRotatef((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (renderContents = this.renderCore(cart, light = cart.getBrightness(time), time)) {
            float blockScale = 0.74f;
            GL11.glScalef((float)blockScale, (float)blockScale, (float)blockScale);
            GL11.glPushAttrib((int)64);
            this.renderContents(cart, light, time);
            GL11.glPopAttrib();
        }
        GL11.glPopMatrix();
    }

    private boolean renderCore(EntityMinecart cart, float light, float time) {
        return this.getCoreRenderer(cart.getClass()).render(this, cart, light, time);
    }

    private void renderContents(EntityMinecart cart, float light, float time) {
        this.getContentRenderer(cart.getClass()).render(this, cart, light, time);
    }

    public CartModelRenderer getCoreRenderer(Class eClass) {
        CartModelRenderer render = renderersCore.get(eClass);
        if (render == null && eClass != EntityMinecart.class) {
            render = this.getCoreRenderer(eClass.getSuperclass());
            if (render == null) {
                render = defaultCoreRenderer;
            }
            renderersCore.put(eClass, render);
        }
        return render;
    }

    public CartContentRenderer getContentRenderer(Class eClass) {
        CartContentRenderer render = renderersContent.get(eClass);
        if (render == null && eClass != EntityMinecart.class) {
            render = this.getContentRenderer(eClass.getSuperclass());
            if (render == null) {
                render = defaultContentRenderer;
            }
            renderersContent.put(eClass, render);
        }
        return render;
    }

    public void doRender(Entity entity, double x, double y, double d2, float yaw, float time) {
        this.renderCart((EntityMinecart)entity, x, y, d2, yaw, time);
    }

    @Override
    public void bindTex(ResourceLocation texture) {
        super.bindTexture(texture);
    }

    public RenderBlocks renderBlocks() {
        return this.field_147909_c;
    }

    public RenderManager getRenderManager() {
        return this.renderManager;
    }

    protected ResourceLocation getEntityTexture(Entity entity) {
        return null;
    }

    public void renderHaloText(Entity entity, String text, double xOffset, double yOffset, double zOffset, int viewDist) {
        this.func_147906_a(entity, text, xOffset, yOffset, zOffset, viewDist);
    }
}

