/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mods.railcraft.api.core.INetworkedObject;
import mods.railcraft.api.core.IOwnable;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.plugins.forge.PlayerPlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.AdjacentTileCache;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.PacketBuilder;
import mods.railcraft.common.util.network.PacketTileEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class RailcraftTileEntity
extends TileEntity
implements INetworkedObject,
IOwnable {
    protected final AdjacentTileCache tileCache = new AdjacentTileCache(this);
    protected int clock = MiscTools.getRand().nextInt();
    private GameProfile owner = new GameProfile(null, "[Railcraft]");
    private boolean sendClientUpdate = false;
    private UUID uuid;

    public static boolean isUseableByPlayerHelper(TileEntity tile, EntityPlayer player) {
        if (tile.isInvalid()) {
            return false;
        }
        if (tile.getWorldObj().getTileEntity(tile.xCoord, tile.yCoord, tile.zCoord) != tile) {
            return false;
        }
        return player.getDistanceSq((double)tile.xCoord, (double)tile.yCoord, (double)tile.zCoord) <= 64.0;
    }

    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    public AdjacentTileCache getTileCache() {
        return this.tileCache;
    }

    public void updateEntity() {
        super.updateEntity();
        ++this.clock;
        if (this.sendClientUpdate) {
            this.sendClientUpdate = false;
            PacketBuilder.instance().sendTileEntityPacket(this);
        }
    }

    public FMLProxyPacket getDescriptionPacket() {
        PacketTileEntity packet = new PacketTileEntity(this);
        return packet.getPacket();
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
    }

    public void markBlockForUpdate() {
        if (this.worldObj != null) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public void notifyBlocksOfNeighborChange() {
        if (this.worldObj != null) {
            WorldPlugin.notifyBlocksOfNeighborChange(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
        }
    }

    public void sendUpdateToClient() {
        if (this.canUpdate()) {
            this.sendClientUpdate = true;
        } else {
            PacketBuilder.instance().sendTileEntityPacket(this);
        }
    }

    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        if (entityliving instanceof EntityPlayer) {
            this.owner = ((EntityPlayer)entityliving).getGameProfile();
        }
    }

    public void onNeighborBlockChange(Block id) {
        this.tileCache.onNeighborChange();
    }

    public void invalidate() {
        this.tileCache.purge();
        super.invalidate();
    }

    public void validate() {
        this.tileCache.purge();
        super.validate();
    }

    public final int getDimension() {
        if (this.worldObj == null) {
            return 0;
        }
        return this.worldObj.provider.dimensionId;
    }

    @Override
    public final GameProfile getOwner() {
        return this.owner;
    }

    public boolean isOwner(GameProfile player) {
        return PlayerPlugin.isSamePlayer(this.owner, player);
    }

    public String getName() {
        return LocalizationPlugin.translate(this.getLocalizationTag());
    }

    @Override
    public abstract String getLocalizationTag();

    public List<String> getDebugOutput() {
        ArrayList<String> debug = new ArrayList<String>();
        debug.add("Railcraft Tile Entity Data Dump");
        debug.add("Object: " + this);
        debug.add(String.format("Coordinates: d=%d, %d,%d,%d", this.worldObj.provider.dimensionId, this.xCoord, this.yCoord, this.zCoord));
        debug.add("Owner: " + (this.owner == null ? "null" : this.owner.getName()));
        debug.addAll(this.tileCache.getDebugOutput());
        return debug;
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.owner.getName() != null) {
            data.setString("owner", this.owner.getName());
        }
        if (this.owner.getId() != null) {
            data.setString("ownerId", this.owner.getId().toString());
        }
        MiscTools.writeUUID(data, "uuid", this.uuid);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.owner = PlayerPlugin.readOwnerFromNBT(data);
        this.uuid = MiscTools.readUUID(data, "uuid");
    }

    public final int getX() {
        return this.xCoord;
    }

    public final int getY() {
        return this.yCoord;
    }

    public final int getZ() {
        return this.zCoord;
    }

    @Override
    public final World getWorld() {
        return this.worldObj;
    }

    public abstract short getId();
}

