/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.brick;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.aesthetics.brick.BrickVariant;
import mods.railcraft.common.blocks.aesthetics.brick.EnumBrick;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class BlockBrick
extends Block {
    private final EnumBrick theme;
    private IIcon[] icons;

    public BlockBrick(EnumBrick theme) {
        super(Material.rock);
        this.theme = theme;
        this.setResistance(15.0f);
        this.setHardness(5.0f);
        this.setStepSound(Block.soundTypeStone);
        this.setCreativeTab(CreativePlugin.RAILCRAFT_TAB);
        this.setHarvestLevel("pickaxe", 0);
    }

    public int damageDropped(int meta) {
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.icons = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:brick." + this.theme.themeTag(), BrickVariant.VALUES.length);
    }

    public IIcon getIcon(int side, int meta) {
        if (meta >= this.icons.length) {
            meta = 0;
        }
        return this.icons[meta];
    }

    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (BrickVariant variant : BrickVariant.VALUES) {
            list.add(this.theme.get(variant, 1));
        }
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }
}

