/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.brick;

import java.util.Locale;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.BlockFactory;
import mods.railcraft.common.blocks.aesthetics.brick.BlockBrick;
import mods.railcraft.common.blocks.aesthetics.brick.BrickVariant;
import mods.railcraft.common.blocks.aesthetics.brick.ItemBrick;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.cube.ReplacerCube;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.plugins.misc.MicroBlockPlugin;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum EnumBrick {
    ABYSSAL{

        @Override
        public void initRecipes() {
            if (EnumCube.ABYSSAL_STONE.isEnabled()) {
                CraftingPlugin.addFurnaceRecipe(EnumCube.ABYSSAL_STONE.getItem(), new ItemStack((Block)this.getBlock(), 1, 2), 0.2f);
                IRockCrusherRecipe recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(EnumCube.ABYSSAL_STONE.getItem(), true, false);
                recipe.addOutput(this.get(BrickVariant.COBBLE, 1), 1.0f);
            }
        }
    }
    ,
    BLEACHEDBONE{
        Item bleachedClay;

        @Override
        public void initBlock() {
            this.bleachedClay = new ItemRailcraft().setUnlocalizedName("railcraft.part.bleached.clay");
            RailcraftRegistry.register(this.bleachedClay);
        }

        @Override
        public void initRecipes() {
            if (this.bleachedClay != null) {
                CraftingPlugin.addShapelessRecipe(new ItemStack(this.bleachedClay), new ItemStack(Items.clay_ball), new ItemStack(Items.dye, 1, 15), new ItemStack(Items.dye, 1, 15), new ItemStack(Items.dye, 1, 15));
                CraftingPlugin.addFurnaceRecipe(new ItemStack(this.bleachedClay), new ItemStack((Block)this.getBlock(), 1, 2), 0.3f);
            }
        }
    }
    ,
    BLOODSTAINED{

        @Override
        public void initRecipes() {
            CraftingPlugin.addShapelessRecipe(new ItemStack((Block)this.getBlock(), 1, 2), new ItemStack(Blocks.sandstone, 1, 2), new ItemStack(Items.rotten_flesh));
            CraftingPlugin.addShapelessRecipe(new ItemStack((Block)this.getBlock(), 1, 2), new ItemStack(Blocks.sandstone, 1, 2), new ItemStack(Items.beef));
        }
    }
    ,
    FROSTBOUND{

        @Override
        public void initRecipes() {
            CraftingPlugin.addShapedRecipe(new ItemStack((Block)this.getBlock(), 8, 2), "III", "ILI", "III", Character.valueOf('I'), new ItemStack(Blocks.ice), Character.valueOf('L'), "gemLapis");
        }
    }
    ,
    INFERNAL{

        @Override
        public void initRecipes() {
            ((ReplacerCube)EnumCube.INFERNAL_BRICK.getBlockDef()).block = this.getBlock();
            CraftingPlugin.addShapedRecipe(new ItemStack((Block)this.getBlock(), 2, 2), "MB", "BM", Character.valueOf('B'), new ItemStack(Blocks.nether_brick), Character.valueOf('M'), new ItemStack(Blocks.soul_sand));
        }
    }
    ,
    QUARRIED{

        @Override
        public void initRecipes() {
            if (EnumCube.QUARRIED_STONE.isEnabled()) {
                CraftingPlugin.addFurnaceRecipe(EnumCube.QUARRIED_STONE.getItem(), new ItemStack((Block)this.getBlock(), 1, 2), 0.2f);
                IRockCrusherRecipe recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(EnumCube.QUARRIED_STONE.getItem(), true, false);
                recipe.addOutput(this.get(BrickVariant.COBBLE, 1), 1.0f);
            }
        }
    }
    ,
    SANDY{

        @Override
        public void initRecipes() {
            ((ReplacerCube)EnumCube.SANDY_BRICK.getBlockDef()).block = this.getBlock();
            CraftingPlugin.addShapedRecipe(new ItemStack((Block)this.getBlock(), 1, 2), "BM", "MB", Character.valueOf('B'), "ingotBrick", Character.valueOf('M'), new ItemStack((Block)Blocks.sand));
        }
    }
    ,
    NETHER{

        @Override
        public ItemStack get(BrickVariant variant, int qty) {
            if (variant == BrickVariant.BRICK) {
                return new ItemStack(Blocks.nether_brick, qty);
            }
            return super.get(variant, qty);
        }

        @Override
        public void initRecipes() {
            CraftingPlugin.addFurnaceRecipe(new ItemStack(Blocks.nether_brick), this.get(BrickVariant.BLOCK, 1), 0.0f);
        }

        @Override
        protected void initVariant(BrickVariant variant) {
            if (variant != BrickVariant.BRICK) {
                super.initVariant(variant);
            }
        }
    };

    public static final EnumBrick[] VALUES;
    private BlockBrick block;

    public final BlockBrick getBlock() {
        return this.block;
    }

    public final String themeTag() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    protected void initBlock() {
    }

    protected void initRecipes() {
    }

    protected void initVariant(BrickVariant variant) {
        MicroBlockPlugin.addMicroBlockCandidate(this.getBlock(), variant.ordinal());
    }

    public final ItemStack get(BrickVariant variant) {
        return this.get(variant, 1);
    }

    public ItemStack get(BrickVariant variant, int qty) {
        if (this.block == null) {
            return null;
        }
        return new ItemStack((Block)this.getBlock(), qty, variant.ordinal());
    }

    public final BlockFactory makeFactory() {
        return new BlockFactory("brick." + this.themeTag()){

            @Override
            protected void doBlockInit() {
                EnumBrick.this.block = new BlockBrick(EnumBrick.this);
                EnumBrick.this.block.setBlockName("railcraft.brick." + EnumBrick.this.themeTag());
                RailcraftRegistry.register(EnumBrick.this.block, ItemBrick.class);
                ForestryPlugin.addBackpackItem("builder", EnumBrick.this.block);
                for (BrickVariant variant : BrickVariant.VALUES) {
                    EnumBrick.this.initVariant(variant);
                }
                EnumBrick.this.initBlock();
            }

            @Override
            protected void doRecipeInit(ModuleManager.Module module) {
                CraftingPlugin.addShapelessRecipe(EnumBrick.this.get(BrickVariant.BRICK, 1), EnumBrick.this.get(BrickVariant.FITTED, 1));
                CraftingPlugin.addShapelessRecipe(EnumBrick.this.get(BrickVariant.FITTED, 1), EnumBrick.this.get(BrickVariant.BLOCK, 1));
                CraftingPlugin.addShapedRecipe(EnumBrick.this.get(BrickVariant.ORNATE, 8), "III", "I I", "III", Character.valueOf('I'), EnumBrick.this.get(BrickVariant.BLOCK, 1));
                CraftingPlugin.addShapelessRecipe(EnumBrick.this.get(BrickVariant.ETCHED, 1), EnumBrick.this.get(BrickVariant.BLOCK, 1), new ItemStack(Items.gunpowder));
                IRockCrusherRecipe recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack((Block)EnumBrick.this.block), false, false);
                recipe.addOutput(EnumBrick.this.get(BrickVariant.COBBLE, 1), 1.0f);
                CraftingPlugin.addFurnaceRecipe(EnumBrick.this.get(BrickVariant.COBBLE, 1), EnumBrick.this.get(BrickVariant.BLOCK, 1), 0.0f);
                EnumBrick.this.initRecipes();
            }
        };
    }

    static {
        VALUES = EnumBrick.values();
    }
}

