/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.cube;

import java.util.Random;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.cube.SimpleCube;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CrushedObsidian
extends SimpleCube {
    @Override
    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        world.scheduleBlockUpdate(i, j, k, (Block)BlockCube.getBlock(), this.tickRate());
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, Block block) {
        world.scheduleBlockUpdate(i, j, k, (Block)BlockCube.getBlock(), this.tickRate());
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random rand) {
        this.tryToFall(world, i, j, k);
    }

    public int tickRate() {
        return 3;
    }

    private void tryToFall(World par1World, int x, int y, int z) {
        if (CrushedObsidian.canFallBelow(par1World, x, y - 1, z) && y >= 0) {
            int var8 = 32;
            if (!BlockSand.fallInstantly && par1World.checkChunksExist(x - var8, y - var8, z - var8, x + var8, y + var8, z + var8)) {
                if (!par1World.isRemote) {
                    EntityFallingBlock entity = new EntityFallingBlock(par1World, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), (Block)BlockCube.getBlock(), EnumCube.CRUSHED_OBSIDIAN.ordinal());
                    par1World.spawnEntityInWorld((Entity)entity);
                }
            } else {
                par1World.setBlockToAir(x, y, z);
                while (CrushedObsidian.canFallBelow(par1World, x, y - 1, z) && y > 0) {
                    --y;
                }
                if (y > 0) {
                    par1World.setBlock(x, y, z, (Block)BlockCube.getBlock(), EnumCube.CRUSHED_OBSIDIAN.ordinal(), 3);
                }
            }
        }
    }

    public static boolean canFallBelow(World world, int x, int y, int z) {
        if (world.isAirBlock(x, y, z)) {
            return true;
        }
        Block block = WorldPlugin.getBlock((IBlockAccess)world, x, y, z);
        if (block == Blocks.fire) {
            return true;
        }
        return block.getMaterial().isLiquid();
    }
}

