/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.post;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.util.misc.EnumColor;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePostEmblem
extends RailcraftTileEntity {
    private ForgeDirection facing = ForgeDirection.NORTH;
    private String emblem = "";
    private EnumColor color = null;

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        this.setFacing(MiscTools.getHorizontalSideClosestToPlayer(this.worldObj, this.xCoord, this.yCoord, this.zCoord, entityliving));
        NBTTagCompound nbt = stack.getTagCompound();
        if (nbt != null) {
            if (nbt.hasKey("color")) {
                this.setColor(EnumColor.fromId(nbt.getByte("color")));
            }
            if (nbt.hasKey("emblem")) {
                this.setEmblem(nbt.getString("emblem"));
            }
        }
    }

    public ForgeDirection getFacing() {
        return this.facing;
    }

    public void setFacing(ForgeDirection f) {
        switch (f) {
            case UP: 
            case DOWN: 
            case UNKNOWN: {
                return;
            }
        }
        if (f != this.facing) {
            this.facing = f;
            this.markBlockForUpdate();
        }
    }

    public String getEmblem() {
        return this.emblem;
    }

    public void setEmblem(String identifier) {
        if (!this.emblem.equals(identifier)) {
            this.emblem = identifier;
            this.sendUpdateToClient();
        }
    }

    public EnumColor getColor() {
        return this.color;
    }

    public void setColor(EnumColor color) {
        if (this.color != color) {
            this.color = color;
            this.sendUpdateToClient();
        }
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setString("emblem", this.emblem);
        data.setByte("facing", (byte)this.facing.ordinal());
        if (this.color != null) {
            data.setByte("color", (byte)this.color.ordinal());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.emblem = data.getString("emblem");
        this.facing = ForgeDirection.getOrientation((int)data.getByte("facing"));
        if (data.hasKey("color")) {
            this.color = EnumColor.fromId(data.getByte("color"));
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte((byte)this.facing.ordinal());
        data.writeByte((byte)(this.color != null ? this.color.ordinal() : -1));
        data.writeUTF(this.emblem);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        byte cByte;
        super.readPacketData(data);
        boolean needsUpdate = false;
        ForgeDirection f = ForgeDirection.getOrientation((int)data.readByte());
        if (this.facing != f) {
            this.facing = f;
            needsUpdate = true;
        }
        if ((cByte = data.readByte()) < 0) {
            if (this.color != null) {
                this.color = null;
                needsUpdate = true;
            }
        } else {
            EnumColor c = EnumColor.fromId(cByte);
            if (this.color != c) {
                this.color = c;
                needsUpdate = true;
            }
        }
        this.emblem = data.readUTF();
        if (needsUpdate) {
            this.markBlockForUpdate();
        }
    }

    @Override
    public String getLocalizationTag() {
        return "tile.railcraft.post.emblem.name";
    }

    @Override
    public short getId() {
        return (short)EnumPost.EMBLEM.ordinal();
    }
}

