/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.stairs;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.aesthetics.EnumBlockMaterial;
import mods.railcraft.common.blocks.aesthetics.stairs.BlockRailcraftStairs;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IIcon;

public class TileStair
extends RailcraftTileEntity {
    private EnumBlockMaterial stair = EnumBlockMaterial.SANDY_BRICK;

    public boolean canUpdate() {
        return false;
    }

    public IIcon getTexture(int side) {
        return this.stair.getIcon(side);
    }

    public EnumBlockMaterial getStair() {
        return this.stair;
    }

    public void setStair(EnumBlockMaterial stair) {
        this.stair = stair;
    }

    @Override
    public String getLocalizationTag() {
        return "tile." + BlockRailcraftStairs.getTag(this.stair);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setString("stair", this.stair.name());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.getTag("stair") instanceof NBTTagString) {
            this.stair = EnumBlockMaterial.fromName(data.getString("stair"));
        } else if (data.getTag("stair") instanceof NBTTagByte) {
            this.stair = EnumBlockMaterial.fromOrdinal(data.getByte("stair"));
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte((byte)this.stair.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.stair = EnumBlockMaterial.fromOrdinal(data.readByte());
    }

    @Override
    public short getId() {
        return 42;
    }
}

