/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.wall;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import mods.railcraft.common.blocks.aesthetics.brick.EnumBrick;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.wall.BlockRailcraftWall;
import mods.railcraft.common.blocks.aesthetics.wall.WallInfo;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public enum EnumWallAlpha implements WallInfo
{
    INFERNAL_BRICK,
    SANDY_BRICK,
    CONCRETE,
    SNOW,
    ICE,
    STONE_BRICK,
    STONE_BRICK_MOSSY,
    STONE_BRICK_CRACKED,
    STONE_BRICK_CHISELED,
    NETHER_BRICK,
    BRICK,
    SANDSTONE,
    SANDSTONE_CHISELED,
    SANDSTONE_SMOOTH,
    OBSIDIAN,
    FROST_BOUND_BRICK;

    public static final EnumWallAlpha[] VALUES;
    private static final List<EnumWallAlpha> creativeList;
    private Block source;
    private int sourceMeta = 0;

    public static void initialize() {
        EnumWallAlpha.INFERNAL_BRICK.source = EnumBrick.INFERNAL.getBlock();
        EnumWallAlpha.SANDY_BRICK.source = EnumBrick.SANDY.getBlock();
        EnumWallAlpha.FROST_BOUND_BRICK.source = EnumBrick.FROSTBOUND.getBlock();
        EnumWallAlpha.CONCRETE.source = BlockCube.getBlock();
        EnumWallAlpha.CONCRETE.sourceMeta = EnumCube.CONCRETE_BLOCK.ordinal();
        EnumWallAlpha.SNOW.source = Blocks.snow;
        EnumWallAlpha.ICE.source = Blocks.ice;
        EnumWallAlpha.STONE_BRICK.source = Blocks.stonebrick;
        EnumWallAlpha.STONE_BRICK.sourceMeta = 0;
        EnumWallAlpha.STONE_BRICK_MOSSY.source = Blocks.stonebrick;
        EnumWallAlpha.STONE_BRICK_MOSSY.sourceMeta = 1;
        EnumWallAlpha.STONE_BRICK_CRACKED.source = Blocks.stonebrick;
        EnumWallAlpha.STONE_BRICK_CRACKED.sourceMeta = 2;
        EnumWallAlpha.STONE_BRICK_CHISELED.source = Blocks.stonebrick;
        EnumWallAlpha.STONE_BRICK_CHISELED.sourceMeta = 3;
        EnumWallAlpha.NETHER_BRICK.source = Blocks.nether_brick;
        EnumWallAlpha.BRICK.source = Blocks.brick_block;
        EnumWallAlpha.SANDSTONE.source = Blocks.sandstone;
        EnumWallAlpha.SANDSTONE.sourceMeta = 0;
        EnumWallAlpha.SANDSTONE_CHISELED.source = Blocks.sandstone;
        EnumWallAlpha.SANDSTONE_CHISELED.sourceMeta = 1;
        EnumWallAlpha.SANDSTONE_SMOOTH.source = Blocks.sandstone;
        EnumWallAlpha.SANDSTONE_SMOOTH.sourceMeta = 2;
        EnumWallAlpha.OBSIDIAN.source = Blocks.obsidian;
        for (EnumWallAlpha wall : VALUES) {
            if (!wall.isEnabled() || wall.source == null) continue;
            if (wall == NETHER_BRICK) {
                CraftingPlugin.addShapedRecipe(wall.getItem(5), "S S", "SSS", Character.valueOf('S'), wall.getSourceItem());
                continue;
            }
            CraftingPlugin.addShapedRecipe(wall.getItem(6), "SSS", "SSS", Character.valueOf('S'), wall.getSourceItem());
        }
        creativeList.addAll(Arrays.asList(VALUES));
    }

    public static WallInfo fromMeta(int id) {
        if (id < 0 || id >= VALUES.length) {
            return VALUES[0];
        }
        return VALUES[id];
    }

    public static List<EnumWallAlpha> getCreativeList() {
        return creativeList;
    }

    @Override
    public Block getSource() {
        return this.source;
    }

    @Override
    public int getSourceMeta() {
        return this.sourceMeta;
    }

    @Override
    public ItemStack getSourceItem() {
        if (this.source == null) {
            return null;
        }
        return new ItemStack(this.source, 1, this.sourceMeta);
    }

    @Override
    public Block getBlock() {
        return BlockRailcraftWall.getBlockAlpha();
    }

    @Override
    public ItemStack getItem() {
        return this.getItem(1);
    }

    @Override
    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    @Override
    public String getTag() {
        return "tile.railcraft.wall." + this.name().replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    @Override
    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(ModuleManager.Module.STRUCTURES) && RailcraftConfig.isSubBlockEnabled(this.getTag()) && this.getBlock() != null;
    }

    @Override
    public float getBlockHardness(World world, int x, int y, int z) {
        switch (this) {
            case CONCRETE: {
                return EnumCube.CONCRETE_BLOCK.getHardness();
            }
        }
        Block block = this.getSource();
        if (block == null) {
            return Blocks.brick_block.getBlockHardness(world, x, y, z);
        }
        return block.getBlockHardness(world, x, y, z);
    }

    @Override
    public float getExplosionResistance(Entity entity) {
        switch (this) {
            case CONCRETE: {
                return EnumCube.CONCRETE_BLOCK.getResistance() * 3.0f / 5.0f;
            }
        }
        Block block = this.getSource();
        if (block == null) {
            return Blocks.brick_block.getExplosionResistance(entity);
        }
        return block.getExplosionResistance(entity);
    }

    static {
        VALUES = EnumWallAlpha.values();
        creativeList = new ArrayList<EnumWallAlpha>();
    }
}

