/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector;

import mods.railcraft.common.blocks.detector.BlockDetector;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.blocks.detector.TileDetector;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemDetector
extends ItemBlock {
    private final BlockDetector blockDetector;

    public ItemDetector(Block block) {
        super(block);
        this.blockDetector = (BlockDetector)block;
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.setUnlocalizedName("railcraft.detector");
    }

    public IIcon getIconFromDamage(int meta) {
        return BlockDetector.getBlock().getIcon(2, meta);
    }

    public String getUnlocalizedName(ItemStack stack) {
        return EnumDetector.fromOrdinal(stack.getItemDamage()).getTag();
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!world.setBlock(x, y, z, (Block)this.blockDetector, metadata, 3)) {
            return false;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileDetector) {
            ((TileDetector)tile).setDetector(EnumDetector.fromOrdinal(stack.getItemDamage()));
        }
        if (world.getBlock(x, y, z) == this.blockDetector) {
            this.blockDetector.onBlockPlacedBy(world, x, y, z, (EntityLivingBase)player, stack);
            this.blockDetector.onPostBlockPlaced(world, x, y, z, metadata);
        }
        return true;
    }
}

