/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.detector.BlockDetector;
import mods.railcraft.common.blocks.detector.Detector;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.SafeNBTWrapper;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileDetector
extends RailcraftTileEntity
implements IGuiReturnHandler {
    public static final float SENSITIVITY = 0.2f;
    private static final int POWER_DELAY = 10;
    public ForgeDirection direction = ForgeDirection.UP;
    public int powerState = 0;
    public Detector detector = Detector.DUMMY;
    private boolean tested;
    private int powerDelay = 0;

    public Detector getDetector() {
        return this.detector;
    }

    public void setDetector(EnumDetector type) {
        this.detector = type.buildHandler();
        this.detector.setTile(this);
        if (this.worldObj != null) {
            this.markBlockForUpdate();
            this.notifyBlocksOfNeighborChange();
        }
    }

    @Override
    public String getLocalizationTag() {
        return this.getDetector().getType().getTag() + ".name";
    }

    public List<EntityMinecart> getCarts() {
        return CartTools.getMinecartsOnAllSides(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 0.2f);
    }

    public boolean blockActivated(EntityPlayer player) {
        return this.detector.blockActivated(player);
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        this.detector.onNeighborBlockChange(block);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setByte("type", (byte)this.detector.getType().ordinal());
        this.detector.writeToNBT(data);
        data.setByte("direction", (byte)this.direction.ordinal());
        data.setByte("powerState", (byte)this.powerState);
        data.setByte("powerDelay", (byte)this.powerDelay);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        SafeNBTWrapper safe = new SafeNBTWrapper(data);
        this.direction = ForgeDirection.getOrientation((int)safe.getByte("direction"));
        this.powerState = data.getByte("powerState");
        this.powerDelay = data.getByte("powerDelay");
        if (data.hasKey("type")) {
            this.setDetector(EnumDetector.fromOrdinal(data.getByte("type")));
        }
        this.detector.readFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.detector.getType().ordinal());
        data.writeByte(this.powerState);
        data.writeByte(this.direction.ordinal());
        this.detector.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        byte type = data.readByte();
        if (this.detector == Detector.DUMMY || this.detector.getType().ordinal() != type) {
            this.setDetector(EnumDetector.fromOrdinal(type));
        }
        this.powerState = data.readByte();
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.detector.readPacketData(data);
        this.markBlockForUpdate();
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (!this.tested) {
            this.tested = true;
            int meta = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
            if (meta != 0) {
                this.worldObj.removeTileEntity(this.xCoord, this.yCoord, this.yCoord);
                BlockDetector block = BlockDetector.getBlock();
                if (block != null) {
                    this.worldObj.setBlock(this.xCoord, this.yCoord, this.yCoord, (Block)block, 0, 3);
                }
            }
        }
        if (this.powerDelay > 0) {
            --this.powerDelay;
        } else if (this.detector.updateInterval() == 0 || this.clock % this.detector.updateInterval() == 0) {
            int newPowerState;
            int n = newPowerState = this.detector.shouldTest() ? this.detector.testCarts(this.getCarts()) : 0;
            if (newPowerState != this.powerState) {
                this.powerState = newPowerState;
                if (this.powerState > 0) {
                    this.powerDelay = 10;
                }
                this.sendUpdateToClient();
                this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, (Block)BlockDetector.getBlock());
                WorldPlugin.notifyBlocksOfNeighborChangeOnSide(this.worldObj, this.xCoord, this.yCoord, this.zCoord, (Block)BlockDetector.getBlock(), this.direction);
            }
        }
    }

    @Override
    public short getId() {
        return 76;
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        this.detector.writeGuiData(data);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.detector.readGuiData(data, sender);
    }
}

