/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.frame;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.ItemBlockRailcraft;
import mods.railcraft.common.blocks.machine.delta.EnumMachineDelta;
import mods.railcraft.common.blocks.machine.delta.TileWire;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemPlate;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.HarvestPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFrame
extends Block
implements IPostConnection {
    private static BlockFrame instance;
    private final int renderId;
    private IIcon[] icons;
    public static boolean flipTextures;
    public static boolean poweredTexture;

    public static BlockFrame getBlock() {
        return instance;
    }

    public static void registerBlock() {
        if (instance == null && RailcraftConfig.isBlockEnabled("frame")) {
            instance = new BlockFrame(Railcraft.proxy.getRenderId());
            RailcraftRegistry.register(instance, ItemBlockRailcraft.class);
            HarvestPlugin.setHarvestLevel(instance, "pickaxe", 1);
            ForestryPlugin.addBackpackItem("builder", instance);
            CraftingPlugin.addShapedRecipe(BlockFrame.getItem(6), new Object[]{"PPP", "I I", "III", Character.valueOf('P'), RailcraftItem.plate, ItemPlate.EnumPlate.IRON, Character.valueOf('I'), RailcraftItem.rebar});
        }
    }

    public static ItemStack getItem() {
        return BlockFrame.getItem(1);
    }

    public static ItemStack getItem(int qty) {
        if (instance == null) {
            return null;
        }
        return new ItemStack((Block)instance, qty, 0);
    }

    public BlockFrame(int renderId) {
        super(Material.glass);
        this.renderId = renderId;
        this.setResistance(10.0f);
        this.setHardness(5.0f);
        this.setStepSound(Block.soundTypeMetal);
        this.setCreativeTab(CreativePlugin.RAILCRAFT_TAB);
        this.setBlockName("railcraft.frame");
    }

    public int getRenderType() {
        return this.renderId;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.icons = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:frame", 3);
    }

    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        return this.getIcon(side, 0);
    }

    public IIcon getIcon(int side, int meta) {
        if (ForgeDirection.UP.ordinal() == side) {
            if (flipTextures) {
                return this.icons[1];
            }
            return poweredTexture ? this.icons[2] : this.icons[0];
        }
        if (flipTextures && ForgeDirection.DOWN.ordinal() == side) {
            return this.icons[0];
        }
        return this.icons[1];
    }

    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        return flipTextures || super.shouldSideBeRendered(world, x, y, z, side);
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.UP;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack current = player.getCurrentEquippedItem();
        if (current != null && InvTools.isItemEqualIgnoreNBT(current, EnumMachineDelta.WIRE.getItem()) && WorldPlugin.setBlock(world, x, y, z, EnumMachineDelta.WIRE.getBlock(), EnumMachineDelta.WIRE.ordinal(), 2)) {
            TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
            if (tile instanceof TileWire) {
                TileWire wire = (TileWire)tile;
                wire.setAddon(TileWire.AddonType.FRAME);
            }
            if (!player.capabilities.isCreativeMode) {
                player.setCurrentItemOrArmor(0, InvTools.depleteItem(current));
            }
            return true;
        }
        return false;
    }

    @Override
    public IPostConnection.ConnectStyle connectsToPost(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return IPostConnection.ConnectStyle.TWO_THIN;
    }
}

