/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine;

import mods.railcraft.common.blocks.ItemBlockRailcraftMultiType;
import mods.railcraft.common.blocks.machine.BlockMachine;
import mods.railcraft.common.gui.tooltips.ToolTip;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemMachine
extends ItemBlockRailcraftMultiType {
    private final BlockMachine machineBlock;

    public ItemMachine(Block block) {
        super(block);
        this.machineBlock = (BlockMachine)block;
        this.setUnlocalizedName("railcraft.machine");
    }

    public IIcon getIconFromDamage(int damage) {
        return this.machineBlock.getIcon(2, damage);
    }

    public String getUnlocalizedName(ItemStack stack) {
        return this.machineBlock.getMachineProxy().getMachine(stack.getItemDamage()).getTag();
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!world.setBlock(x, y, z, (Block)this.machineBlock, metadata, 3)) {
            return false;
        }
        if (world.getBlock(x, y, z) == this.machineBlock) {
            this.machineBlock.onBlockPlacedBy(world, x, y, z, (EntityLivingBase)player, stack);
            this.machineBlock.onPostBlockPlaced(world, x, y, z, metadata);
            this.machineBlock.initFromItem(world, x, y, z, stack);
        }
        return true;
    }

    @Override
    public ToolTip getToolTip(ItemStack stack, EntityPlayer player, boolean adv) {
        return this.machineBlock.getMachineProxy().getMachine(stack.getItemDamage()).getToolTip(stack, player, adv);
    }
}

