/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine;

import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileMachineItem
extends TileMachineBase
implements IInventory {
    private StandaloneInventory inv;

    protected TileMachineItem() {
        this.inv = new StandaloneInventory(0, this);
    }

    protected TileMachineItem(int invSize) {
        this.inv = new StandaloneInventory(invSize, this);
    }

    protected void setInventorySize(int invSize) {
        this.inv = new StandaloneInventory(invSize, this);
    }

    protected StandaloneInventory getInventory() {
        return this.inv;
    }

    protected void dropItem(ItemStack stack) {
        InvTools.dropItem(stack, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public int getSizeInventory() {
        return this.inv.getSizeInventory();
    }

    public ItemStack decrStackSize(int i, int j) {
        return this.inv.decrStackSize(i, j);
    }

    public int getInventoryStackLimit() {
        return this.inv.getInventoryStackLimit();
    }

    public ItemStack getStackInSlot(int i) {
        return this.inv.getStackInSlot(i);
    }

    public String getInventoryName() {
        return this.getName();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inv.readFromNBT("Items", data);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.inv.writeToNBT("Items", data);
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.inv.setInventorySlotContents(i, itemstack);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return RailcraftTileEntity.isUseableByPlayerHelper(this, player);
    }
}

