/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.alpha.TileAnchorWorld;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forge.PlayerPlugin;
import mods.railcraft.common.util.collections.ItemMap;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TileAnchorPersonal
extends TileAnchorWorld {
    private static final int MINUTES_BEFORE_DISABLE = 5;
    private long ticksSincePlayerLogged;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.PERSONAL_ANCHOR;
    }

    @Override
    protected ForgeChunkManager.Ticket getTicketFromForge() {
        return ForgeChunkManager.requestPlayerTicket((Object)Railcraft.getMod(), (String)PlayerPlugin.getUsername(this.worldObj, this.getOwner()), (World)this.worldObj, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
    }

    @Override
    public ItemMap<Float> getFuelMap() {
        return RailcraftConfig.anchorFuelPersonal;
    }

    @Override
    protected boolean meetsTicketRequirements() {
        return PlayerPlugin.isPlayerConnected(this.getOwner()) && super.meetsTicketRequirements();
    }

    @Override
    public void updateEntity() {
        if (Game.isHost(this.worldObj) && this.hasActiveTicket()) {
            this.ticksSincePlayerLogged = PlayerPlugin.isPlayerConnected(this.getOwner()) ? 0L : ++this.ticksSincePlayerLogged;
            if (this.ticksSincePlayerLogged > 6000L) {
                this.releaseTicket();
            }
        }
        super.updateEntity();
    }
}

