/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mods.railcraft.api.crafting.ICokeOvenRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.TileMultiBlockOven;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.FakeTank;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileCokeOven
extends TileMultiBlockOven
implements IFluidHandler,
ISidedInventory {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int SLOT_LIQUID_OUTPUT = 2;
    public static final int SLOT_LIQUID_INPUT = 3;
    private static final int COOK_STEP_LENGTH = 50;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 4);
    private static final int TANK_CAPACITY = 64000;
    private static final List<MultiBlockPattern> patterns = new ArrayList<MultiBlockPattern>();
    private final TankManager tankManager = new TankManager();
    private final StandardTank tank;
    private final IInventory invInput = new InventoryMapper(this, 0, 1);
    private final IInventory invOutput = new InventoryMapper(this, 1, 2, false);
    public int cookTimeTotal = 3600;
    private int finishedAt;

    public TileCokeOven() {
        super("railcraft.gui.coke.oven", 4, patterns);
        this.tank = new StandardTank(64000, this);
        this.tankManager.add(this.tank);
    }

    public static void placeCokeOven(World world, int x, int y, int z, int creosote, ItemStack input, ItemStack output) {
        Iterator<MultiBlockPattern> iterator = patterns.iterator();
        if (iterator.hasNext()) {
            MultiBlockPattern pattern = iterator.next();
            HashMap<Character, Integer> blockMapping = new HashMap<Character, Integer>();
            blockMapping.put(Character.valueOf('B'), EnumMachineAlpha.COKE_OVEN.ordinal());
            blockMapping.put(Character.valueOf('W'), EnumMachineAlpha.COKE_OVEN.ordinal());
            TileEntity tile = pattern.placeStructure(world, x, y, z, RailcraftBlocks.getBlockMachineAlpha(), blockMapping);
            if (tile instanceof TileCokeOven) {
                TileCokeOven master = (TileCokeOven)tile;
                master.tank.setFluid(Fluids.CREOSOTE.get(creosote));
                master.inv.setInventorySlotContents(0, input);
                master.inv.setInventorySlotContents(1, output);
            }
            return;
        }
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.COKE_OVEN;
    }

    public TankManager getTankManager() {
        TileCokeOven mBlock = (TileCokeOven)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager;
        }
        return null;
    }

    @Override
    public IIcon getIcon(int side) {
        if (this.getPatternMarker() == 'W' && this.isStructureValid()) {
            if (this.isBurning()) {
                return this.getMachineType().getTexture(7);
            }
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(0);
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        if (this.isStructureValid() && FluidHelper.handleRightClick(this, ForgeDirection.getOrientation((int)side), player, false, true)) {
            return true;
        }
        if (FluidItemHelper.isContainer(player.inventory.getCurrentItem())) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public int getTotalCookTime() {
        TileCokeOven mBlock = (TileCokeOven)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.cookTimeTotal;
        }
        return 3600;
    }

    @Override
    public int getBurnProgressScaled(int i) {
        return (this.getTotalCookTime() - this.getCookTime()) * i / this.getTotalCookTime();
    }

    @Override
    public boolean needsFuel() {
        ItemStack fuel = this.getStackInSlot(0);
        return fuel == null || fuel.stackSize < 8;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isHost(this.getWorld()) && this.isMaster()) {
            ItemStack bottomSlot;
            ItemStack topSlot;
            ItemStack input;
            if (this.clock > this.finishedAt + 50 + 5 && this.cookTime <= 0) {
                this.setCooking(false);
            }
            if ((input = this.getStackInSlot(0)) != null && input.stackSize > 0 && !InvTools.isSynthetic(input)) {
                if (!this.paused && this.clock % 50 == 0) {
                    ItemStack output = this.getStackInSlot(1);
                    ICokeOvenRecipe recipe = RailcraftCraftingManager.cokeOven.getRecipe(input);
                    if (recipe != null) {
                        if ((output == null || output.isItemEqual(recipe.getOutput()) && output.stackSize + recipe.getOutput().stackSize <= output.getMaxStackSize()) && this.tank.fill(recipe.getFluidOutput(), false) >= recipe.getFluidOutput().amount) {
                            this.cookTimeTotal = recipe.getCookTime();
                            this.cookTime += 50;
                            this.setCooking(true);
                            if (this.cookTime >= recipe.getCookTime()) {
                                this.cookTime = 0;
                                this.finishedAt = this.clock;
                                this.decrStackSize(0, 1);
                                if (output == null) {
                                    this.setInventorySlotContents(1, recipe.getOutput());
                                } else {
                                    output.stackSize += recipe.getOutput().stackSize;
                                }
                                this.tank.fill(recipe.getFluidOutput(), true);
                                this.sendUpdateToClient();
                            }
                        } else {
                            this.cookTime = 0;
                            this.setCooking(false);
                        }
                    } else {
                        this.cookTime = 0;
                        this.setCooking(false);
                        this.setInventorySlotContents(0, null);
                        this.dropItem(input);
                    }
                }
            } else {
                this.cookTime = 0;
                this.setCooking(false);
            }
            if ((topSlot = this.getStackInSlot(3)) != null && !FluidItemHelper.isContainer(topSlot)) {
                this.setInventorySlotContents(3, null);
                this.dropItem(topSlot);
            }
            if ((bottomSlot = this.getStackInSlot(2)) != null && !FluidItemHelper.isContainer(bottomSlot)) {
                this.setInventorySlotContents(2, null);
                this.dropItem(bottomSlot);
            }
            if (this.clock % 8 == 0) {
                FluidHelper.fillContainers(this, this, 3, 2, Fluids.CREOSOTE.get());
            }
        }
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock masterBlock = this.getMasterBlock();
        if (masterBlock != null && this.isStructureValid()) {
            GuiHandler.openGui(EnumGui.COKE_OVEN, player, this.worldObj, masterBlock.xCoord, masterBlock.yCoord, masterBlock.zCoord);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.tankManager.readTanksFromNBT(data);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.tankManager.writeTanksToNBT(data);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.drain(0, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (!Fluids.CREOSOTE.is(resource)) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == null || Fluids.CREOSOTE.is(fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection dir) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTankInfo();
        }
        return FakeTank.INFO;
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (!super.isItemValidForSlot(slot, stack)) {
            return false;
        }
        switch (slot) {
            case 0: {
                return RailcraftCraftingManager.cokeOven.getRecipe(stack) != null;
            }
            case 3: {
                return FluidItemHelper.isRoomInContainer(stack);
            }
        }
        return false;
    }

    public int[] getAccessibleSlotsFromSide(int var1) {
        return SLOTS;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.isItemValidForSlot(slot, stack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot == 1 || slot == 2;
    }

    static {
        char[][][] map = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'W', 'A', 'W', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map, 2, 1, 2));
    }
}

