/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.alpha.ai.EntityAIMateBreeding;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.filters.StackFilter;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.ITileExtraDataHandler;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketTileExtraData;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import org.apache.logging.log4j.Level;

public class TileFeedStation
extends TileMachineItem
implements ITileExtraDataHandler {
    private static final int AREA = 3;
    private static final int MIN_FEED_INTERVAL = 128;
    private static final int FEED_VARIANCE = 256;
    private static final byte ANIMALS_PER_FOOD = 2;
    private static final Random rand = MiscTools.getRand();
    private int feedTime;
    private byte feedCounter;
    private boolean powered;

    public TileFeedStation() {
        super(1);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.FEED_STATION;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.FEED_STATION, player, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    @Override
    public IIcon getIcon(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        ItemStack feed = this.getStackInSlot(0);
        if (this.clock % 32 == 0 && (feed == null || feed.stackSize < feed.getMaxStackSize())) {
            List<IInventory> chests = InvTools.getAdjacentInventories(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            for (IInventory inv : chests) {
                if (InvTools.moveOneItem(inv, (IInventory)this, (IStackFilter)StackFilter.FEED) != null) break;
            }
        }
        feed = this.getStackInSlot(0);
        --this.feedTime;
        if (!this.powered && feed != null && feed.stackSize > 0 && this.feedTime <= 0) {
            this.feedTime = 128 + rand.nextInt(256);
            AxisAlignedBB box = AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)(this.yCoord - 1), (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 3), (double)(this.zCoord + 1));
            box = box.expand(3.0, 0.0, 3.0);
            List animals = this.worldObj.getEntitiesWithinAABB(EntityAnimal.class, box);
            for (EntityAnimal target : animals) {
                if (!target.isBreedingItem(this.getStackInSlot(0)) || !this.feedAnimal(target)) continue;
                if (this.feedCounter <= 0) {
                    this.setInventorySlotContents(0, InvTools.depleteItem(feed));
                    this.feedCounter = (byte)2;
                }
                this.feedCounter = (byte)(this.feedCounter - 1);
                this.sendFeedPacket(target);
                break;
            }
        }
    }

    public void sendFeedPacket(EntityAnimal animal) {
        try {
            PacketTileExtraData pkt = new PacketTileExtraData(this);
            DataOutputStream data = pkt.getDataStream();
            data.writeInt(animal.getEntityId());
            PacketDispatcher.sendToAllAround(pkt, new NetworkRegistry.TargetPoint(this.worldObj.provider.dimensionId, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, 80.0));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdatePacket(DataInputStream data) throws IOException {
        Entity e = this.worldObj.getEntityByID(data.readInt());
        if (e instanceof EntityAnimal) {
            this.feedAnimal((EntityAnimal)e);
        }
    }

    private boolean feedAnimal(EntityAnimal animal) {
        if (animal == null) {
            return false;
        }
        try {
            if (animal.getGrowingAge() == 0 && !animal.isInLove()) {
                if (Game.isHost(this.worldObj)) {
                    EntityAIMateBreeding.modifyAI(animal);
                }
                animal.func_146082_f(null);
                for (int i = 0; i < 7; ++i) {
                    double d = rand.nextGaussian() * 0.02;
                    double d1 = rand.nextGaussian() * 0.02;
                    double d2 = rand.nextGaussian() * 0.02;
                    this.worldObj.spawnParticle("heart", animal.posX + (double)(rand.nextFloat() * animal.width * 2.0f) - (double)animal.width, animal.posY + 0.5 + (double)(rand.nextFloat() * animal.height), animal.posZ + (double)(rand.nextFloat() * animal.width * 2.0f) - (double)animal.width, d, d1, d2);
                }
                return true;
            }
        }
        catch (Throwable ex) {
            Game.log(Level.ERROR, "Feed Station encountered error, {0}", ex);
        }
        return false;
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        this.powered = PowerPlugin.isBlockBeingPowered(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.getBoolean("powered");
        this.feedCounter = data.getByte("feedCounter");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("powered", this.powered);
        data.setByte("feedCounter", this.feedCounter);
    }
}

