/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha.ai;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import mods.railcraft.common.blocks.machine.alpha.ai.EntityAIDespawn;
import mods.railcraft.common.blocks.machine.alpha.ai.EntityAISitBred;
import mods.railcraft.common.blocks.machine.alpha.ai.EntityAISitRandom;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.world.World;

public class EntityAIMateBreeding
extends EntityAIBase {
    private static final int MAX_ANIMALS = 6;
    private final EntityAnimal theAnimal;
    World theWorld;
    private EntityAnimal targetMate;
    int spawnBabyDelay = 0;
    float moveSpeed;

    public EntityAIMateBreeding(EntityAnimal animal, float moveSpeed) {
        this.theAnimal = animal;
        this.theWorld = animal.worldObj;
        this.moveSpeed = moveSpeed;
    }

    public boolean shouldExecute() {
        if (!this.theAnimal.isInLove()) {
            return false;
        }
        List nearbyEntites = this.theAnimal.worldObj.getEntitiesWithinAABB(EntityAnimal.class, this.theAnimal.boundingBox.expand(1.0, 1.0, 1.0));
        if (nearbyEntites.size() > 6) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean continueExecuting() {
        return this.targetMate.isEntityAlive() && this.targetMate.isInLove() && this.spawnBabyDelay < 60;
    }

    public void resetTask() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void updateTask() {
        this.theAnimal.getLookHelper().setLookPositionWithEntity((Entity)this.targetMate, 10.0f, (float)this.theAnimal.getVerticalFaceSpeed());
        this.theAnimal.getNavigator().tryMoveToEntityLiving((Entity)this.targetMate, (double)this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay == 60) {
            double litterSize = 1.75;
            if (this.theAnimal instanceof EntityCow || this.theAnimal instanceof EntitySheep) {
                litterSize = 0.0;
            }
            int babies = 1;
            if (litterSize > 0.0) {
                babies += (int)Math.round(Math.abs(this.theAnimal.getRNG().nextGaussian()) * litterSize);
            }
            for (int i = 0; i < babies; ++i) {
                this.spawnBaby();
            }
        }
    }

    public static void modifyAI(EntityAnimal animal) {
        boolean tame = animal instanceof EntityTameable;
        int matePriority = -1;
        int sitPriority = -1;
        boolean hasDespawn = false;
        Iterator it = animal.tasks.taskEntries.iterator();
        while (it.hasNext()) {
            EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)it.next();
            if (tame && task.action instanceof EntityAISit) {
                sitPriority = task.priority;
                it.remove();
                continue;
            }
            if (task.action instanceof EntityAIMate) {
                matePriority = task.priority;
                it.remove();
                continue;
            }
            if (!(task.action instanceof EntityAIDespawn)) continue;
            hasDespawn = true;
        }
        if (tame) {
            ((EntityTameable)animal).setTamed(true);
        }
        if (!hasDespawn) {
            animal.tasks.addTask(0, (EntityAIBase)new EntityAIDespawn((EntityAgeable)animal));
        }
        if (matePriority > 0) {
            animal.tasks.addTask(matePriority, (EntityAIBase)new EntityAIMateBreeding(animal, 0.25f));
            if (tame) {
                animal.tasks.addTask(6, (EntityAIBase)new EntityAISitRandom((EntityTameable)animal));
            }
        }
        if (sitPriority > 0) {
            EntityAISitBred aiSit = new EntityAISitBred((EntityTameable)animal);
            animal.tasks.addTask(sitPriority, (EntityAIBase)aiSit);
            ObfuscationReflectionHelper.setPrivateValue(EntityTameable.class, (Object)((EntityTameable)animal), (Object)((Object)aiSit), (int)0);
        }
    }

    private EntityAnimal getNearbyMate() {
        EntityAnimal target;
        float var1 = 8.0f;
        List var2 = this.theWorld.getEntitiesWithinAABB(this.theAnimal.getClass(), this.theAnimal.boundingBox.expand((double)var1, (double)var1, (double)var1));
        Iterator entity = var2.iterator();
        do {
            if (entity.hasNext()) continue;
            return null;
        } while (!this.canMateWith(this.theAnimal, target = (EntityAnimal)entity.next()));
        return target;
    }

    public boolean canMateWith(EntityAnimal animal, EntityAnimal target) {
        if (target == animal) {
            return false;
        }
        if (animal.getClass() == target.getClass()) {
            boolean isSitting = target instanceof EntityTameable && ((EntityTameable)target).isSitting();
            return !isSitting && animal.isInLove() && target.isInLove();
        }
        return false;
    }

    private void spawnBaby() {
        EntityAgeable baby = this.theAnimal.createChild((EntityAgeable)this.targetMate);
        if (baby instanceof EntityAnimal) {
            this.theAnimal.setGrowingAge(3600);
            this.targetMate.setGrowingAge(3600);
            this.theAnimal.resetInLove();
            this.targetMate.resetInLove();
            baby.setGrowingAge(-12000);
            EntityAIMateBreeding.modifyAI((EntityAnimal)baby);
            Random rand = this.theAnimal.getRNG();
            if (baby instanceof EntityOcelot) {
                EntityOcelot cat = (EntityOcelot)baby;
                if (rand.nextInt(10) == 0) {
                    cat.setTameSkin(baby.worldObj.rand.nextInt(4));
                }
            }
            double x = rand.nextGaussian() * 0.2;
            double z = rand.nextGaussian() * 0.2;
            baby.setLocationAndAngles(this.theAnimal.posX + x, this.theAnimal.posY, this.theAnimal.posZ + z, 0.0f, 0.0f);
            this.theWorld.spawnEntityInWorld((Entity)baby);
            for (int i = 0; i < 7; ++i) {
                double px = rand.nextGaussian() * 0.02;
                double py = rand.nextGaussian() * 0.02;
                double pz = rand.nextGaussian() * 0.02;
                this.theWorld.spawnParticle("heart", this.theAnimal.posX + (double)(rand.nextFloat() * this.theAnimal.width * 2.0f) - (double)this.theAnimal.width, this.theAnimal.posY + 0.5 + (double)(rand.nextFloat() * this.theAnimal.height), this.theAnimal.posZ + (double)(rand.nextFloat() * this.theAnimal.width * 2.0f) - (double)this.theAnimal.width, px, py, pz);
            }
        }
    }
}

