/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.beta.TileBoiler;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.plugins.buildcraft.triggers.ITemperature;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.ITileFilter;
import mods.railcraft.common.util.steam.ISteamUser;
import mods.railcraft.common.util.steam.SteamBoiler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileBoilerFirebox
extends TileBoiler
implements IInventory,
ISidedInventory,
ITemperature {
    protected static final int SLOT_LIQUID_INPUT = 0;
    protected static final int SLOT_LIQUID_OUTPUT = 1;
    public final SteamBoiler boiler;
    private boolean wasLit;
    protected final StandaloneInventory inventory;
    protected IInventory invWaterInput = new InventoryMapper(this, 0, 1);
    protected IInventory invWaterOutput = new InventoryMapper(this, 1, 1, false);

    protected TileBoilerFirebox(int invSize) {
        this.inventory = new StandaloneInventory(invSize, this);
        this.boiler = new SteamBoiler(this.tankWater, this.tankSteam);
        this.boiler.setTile(this);
    }

    @Override
    public IIcon getIcon(int side) {
        if (side > 1 && this.isBurning()) {
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    protected void onPatternLock(MultiBlockPattern pattern) {
        int capacity = this.getNumTanks() * 1000;
        this.tankManager.setCapacity(1, capacity * this.getSteamCapacityPerTank());
        this.tankManager.setCapacity(0, capacity * 4);
        this.boiler.setMaxHeat(((TileBoiler.BoilerPattern)pattern).maxHeat);
        this.boiler.setTicksPerCycle(((TileBoiler.BoilerPattern)pattern).ticksPerCycle);
    }

    public boolean isBurning() {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock == null) {
            return false;
        }
        return mBlock.boiler.isBurning();
    }

    protected void updateLighting() {
        boolean b = this.isBurning();
        if (this.wasLit != b) {
            this.wasLit = b;
            this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord);
            this.markBlockForUpdate();
        }
    }

    @Override
    public int getLightValue() {
        if (this.isStructureValid() && this.isBurning()) {
            return 13;
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(Random random) {
        if (this.isStructureValid()) {
            this.updateLighting();
            if (this.isBurning() && random.nextInt(100) < 20) {
                float f = (float)this.xCoord + 0.5f;
                float f1 = (float)this.yCoord + 0.4375f + random.nextFloat() * 3.0f / 16.0f;
                float f2 = (float)this.zCoord + 0.5f;
                float f3 = 0.52f;
                float f4 = random.nextFloat() * 0.6f - 0.3f;
                this.worldObj.spawnParticle("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                this.worldObj.spawnParticle("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                this.worldObj.spawnParticle("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                this.worldObj.spawnParticle("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public ITileFilter getOutputFilter() {
        return ISteamUser.FILTER;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (!this.isMaster || this.getState() == TileMultiBlock.MultiBlockState.INVALID) {
            this.boiler.reduceHeat(this.getNumTanks());
            return;
        }
        if (this.isMaster) {
            this.process();
            this.boiler.tick(this.getNumTanks());
            if (this.clock % 8 == 0) {
                this.processBuckets();
            }
        }
    }

    protected abstract void process();

    protected void processBuckets() {
        FluidHelper.drainContainers(this, this.inventory, 0, 1);
    }

    @Override
    protected void onPatternChanged() {
        super.onPatternChanged();
        this.reset();
    }

    @Override
    protected void onMasterChanged() {
        super.onMasterChanged();
        this.reset();
    }

    private void reset() {
        this.tankManager.get(1).setFluid(null);
        this.boiler.reset();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.tankManager.writeTanksToNBT(data);
        this.inventory.writeToNBT("inv", data);
        this.boiler.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.tankManager.readTanksFromNBT(data);
        this.inventory.readFromNBT("inv", data);
        this.boiler.readFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.tankManager.writePacketData(data);
        data.writeBoolean(this.boiler.isBurning());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.tankManager.readPacketData(data);
        this.boiler.setBurning(data.readBoolean());
    }

    public ItemStack decrStackSize(int i, int j) {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.inventory.decrStackSize(i, j);
        }
        return null;
    }

    public ItemStack getStackInSlot(int i) {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.inventory.getStackInSlot(i);
        }
        return this.inventory.getStackInSlot(i);
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.inventory.setInventorySlotContents(i, itemstack);
        }
    }

    public String getInventoryName() {
        return this.getName();
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public int getSizeInventory() {
        return this.inventory.getSizeInventory();
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return null;
    }

    protected boolean handleClick(EntityPlayer player, int side) {
        return FluidHelper.handleRightClick(this, ForgeDirection.getOrientation((int)side), player, true, false);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    @Override
    public float getTemperature() {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null) {
            return (float)mBlock.boiler.getHeat();
        }
        return 20.0f;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return RailcraftTileEntity.isUseableByPlayerHelper(this, player);
    }
}

