/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import java.util.EnumMap;
import java.util.Map;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileChestRailcraft;
import mods.railcraft.common.items.Metal;
import mods.railcraft.common.util.inventory.filters.ComplexStackFilter;
import mods.railcraft.common.util.inventory.filters.ExclusionStackFilter;
import mods.railcraft.common.util.inventory.manipulators.InventoryManipulator;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.inventory.IInventory;

public class TileChestMetals
extends TileChestRailcraft {
    private static final int TICK_PER_CONDENSE = 16;
    private static final Map<Metal, IStackFilter> nuggetFilters = new EnumMap<Metal, IStackFilter>(Metal.class);
    private static final Map<Metal, IStackFilter> ingotFilters = new EnumMap<Metal, IStackFilter>(Metal.class);
    private static final Map<Metal, IStackFilter> blockFilters = new EnumMap<Metal, IStackFilter>(Metal.class);
    private Target target = Target.NUGGET_CONDENSE;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.METALS_CHEST;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.clock % 16 == 0 && Game.isHost(this.worldObj) && !this.target.evaluate(this)) {
            this.target = this.target.next();
        }
    }

    static {
        for (Metal m : Metal.VALUES) {
            nuggetFilters.put(m, ComplexStackFilter.and(new ExclusionStackFilter(m.getNugget()), m.nuggetFilter));
            ingotFilters.put(m, ComplexStackFilter.and(new ExclusionStackFilter(m.getIngot()), m.ingotFilter));
            blockFilters.put(m, ComplexStackFilter.and(new ExclusionStackFilter(m.getBlock()), m.blockFilter));
        }
    }

    static enum Target {
        NUGGET_CONDENSE{

            @Override
            public boolean evaluate(IInventory inv) {
                InventoryManipulator im = InventoryManipulator.get(inv);
                for (Metal metal : Metal.VALUES) {
                    if (metal.getIngot() == null || !im.canRemoveItems(metal.nuggetFilter, 9) || !im.canAddStack(metal.getIngot())) continue;
                    im.removeItems(metal.nuggetFilter, 9);
                    im.addStack(metal.getIngot());
                    return true;
                }
                return false;
            }
        }
        ,
        INGOT_CONDENSE{

            @Override
            public boolean evaluate(IInventory inv) {
                InventoryManipulator im = InventoryManipulator.get(inv);
                for (Metal metal : Metal.VALUES) {
                    if (metal.getBlock() == null || !im.canRemoveItems(metal.ingotFilter, 9) || !im.canAddStack(metal.getBlock())) continue;
                    im.removeItems(metal.ingotFilter, 9);
                    im.addStack(metal.getBlock());
                    return true;
                }
                return false;
            }
        }
        ,
        NUGGET_SWAP{

            @Override
            public boolean evaluate(IInventory inv) {
                InventoryManipulator im = InventoryManipulator.get(inv);
                for (Metal metal : Metal.VALUES) {
                    IStackFilter filter = (IStackFilter)nuggetFilters.get((Object)metal);
                    if (metal.getNugget() == null || !im.canRemoveItems(filter, 1) || !im.canAddStack(metal.getNugget())) continue;
                    im.removeItems(filter, 1);
                    im.addStack(metal.getNugget());
                    return true;
                }
                return false;
            }
        }
        ,
        INGOT_SWAP{

            @Override
            public boolean evaluate(IInventory inv) {
                InventoryManipulator im = InventoryManipulator.get(inv);
                for (Metal metal : Metal.VALUES) {
                    IStackFilter filter = (IStackFilter)ingotFilters.get((Object)metal);
                    if (metal.getIngot() == null || !im.canRemoveItems(filter, 1) || !im.canAddStack(metal.getIngot())) continue;
                    im.removeItems(filter, 1);
                    im.addStack(metal.getIngot());
                    return true;
                }
                return false;
            }
        }
        ,
        BLOCK_SWAP{

            @Override
            public boolean evaluate(IInventory inv) {
                InventoryManipulator im = InventoryManipulator.get(inv);
                for (Metal metal : Metal.VALUES) {
                    IStackFilter filter = (IStackFilter)blockFilters.get((Object)metal);
                    if (metal.getBlock() == null || !im.canRemoveItems(filter, 1) || !im.canAddStack(metal.getBlock())) continue;
                    im.removeItems(filter, 1);
                    im.addStack(metal.getBlock());
                    return true;
                }
                return false;
            }
        };

        public static final Target[] VALUES;

        public abstract boolean evaluate(IInventory var1);

        public Target next() {
            Target next = VALUES[(this.ordinal() + 1) % VALUES.length];
            return next;
        }

        static {
            VALUES = Target.values();
        }
    }
}

