/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.alpha.TileAnchorWorld;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public class TileSentinel
extends TileMachineBase {
    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.SENTINEL;
    }

    @Override
    public IIcon getIcon(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        IToolCrowbar crowbar;
        ItemStack current = player.getCurrentEquippedItem();
        if (current != null && current.getItem() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.getItem()).canWhack(player, current, this.xCoord, this.yCoord, this.zCoord)) {
            WorldCoordinate target = TileAnchorWorld.getTarget(player);
            if (target == null) {
                TileAnchorWorld.setTarget(this, player);
            } else if (this.worldObj.provider.dimensionId != target.dimension) {
                ChatPlugin.sendLocalizedChatFromServer(player, "railcraft.gui.anchor.pair.fail.dimension", this.getLocalizationTag());
            } else if (new WorldCoordinate(this).equals(target)) {
                TileAnchorWorld.removeTarget(player);
                ChatPlugin.sendLocalizedChatFromServer(player, "railcraft.gui.anchor.pair.cancel", this.getLocalizationTag());
            } else {
                TileEntity tile = TileAnchorWorld.getTargetAt(player, this, target);
                if (tile instanceof TileAnchorWorld) {
                    ((TileAnchorWorld)tile).setSentinel(player, new WorldCoordinate(this));
                } else if (tile != null) {
                    ChatPlugin.sendLocalizedChatFromServer(player, "railcraft.gui.anchor.pair.fail.invalid", this.getLocalizationTag());
                }
            }
            crowbar.onWhack(player, current, this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public float getResistance(Entity exploder) {
        return 60.0f;
    }

    @Override
    public float getHardness() {
        return 20.0f;
    }
}

