/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.delta;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.delta.EnumMachineDelta;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class TileCage
extends TileMachineBase {
    private boolean isOpen = false;
    private EntityLiving entity;
    private EntityLookHelper lookHelper;
    private EntityBodyHelper bodyHelper;
    private double lookX;
    private double lookZ;
    private Entity lookTarget;
    private int lookCounter;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineDelta.CAGE;
    }

    @Override
    public IIcon getIcon(int side) {
        if (side != 0 && side != 1 && this.isOpen) {
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        if (Game.isHost(this.worldObj)) {
            this.isOpen = !this.isOpen;
            this.sendUpdateToClient();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getEntity() {
        if (this.entity == null) {
            this.entity = (EntityLiving)EntityList.createEntityByName((String)"Chicken", (World)null);
            this.lookHelper = new EntityLookHelper(this.entity);
            this.bodyHelper = new EntityBodyHelper((EntityLivingBase)this.entity);
        }
        return this.entity;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.worldObj) && this.entity != null) {
            this.entity.setPosition(0.0, 0.0, 0.0);
            this.entity.prevRotationYawHead = this.entity.rotationYawHead;
            this.entity.prevRotationYaw = this.entity.rotationYaw;
            this.entity.prevRotationPitch = this.entity.rotationPitch;
            this.entity.prevRenderYawOffset = this.entity.renderYawOffset;
            if (this.lookCounter > 0) {
                --this.lookCounter;
                if (this.lookTarget == null) {
                    this.lookHelper.setLookPosition(this.lookX, (double)this.entity.getEyeHeight(), this.lookZ, 10.0f, (float)this.entity.getVerticalFaceSpeed());
                } else {
                    this.lookHelper.setLookPosition(this.lookTarget.posX - ((double)this.xCoord + 0.5), this.lookTarget.posY - (double)((float)this.yCoord + this.entity.getEyeHeight()), this.lookTarget.posZ - ((double)this.zCoord + 0.5), 10.0f, (float)this.entity.getVerticalFaceSpeed());
                }
            }
            this.lookHelper.onUpdateLook();
            this.bodyHelper.func_75664_a();
            if (this.lookCounter <= 0) {
                this.lookTarget = null;
                if (this.entity.getRNG().nextDouble() < 0.1) {
                    List<EntityPlayer> nearby = MiscTools.getNearbyEntities(this.worldObj, EntityPlayer.class, this.xCoord, this.yCoord - 1, this.yCoord + 3, this.zCoord, 5.0f);
                    if (!nearby.isEmpty() && this.entity.getRNG().nextDouble() < 0.4) {
                        this.lookTarget = (Entity)nearby.get(MiscTools.RANDOM.nextInt(nearby.size()));
                        this.lookCounter = 60 + this.entity.getRNG().nextInt(60);
                    } else {
                        double d0 = Math.PI * 2 * this.entity.getRNG().nextDouble();
                        this.lookX = Math.cos(d0);
                        this.lookZ = Math.sin(d0);
                        this.lookCounter = 20 + this.entity.getRNG().nextInt(20);
                    }
                }
            }
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.isOpen);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean o = data.readBoolean();
        if (this.isOpen != o) {
            this.isOpen = o;
            this.markBlockForUpdate();
        }
    }
}

