/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.delta;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.api.electricity.IElectricGrid;
import mods.railcraft.common.blocks.frame.BlockFrame;
import mods.railcraft.common.blocks.machine.BoundingBoxManager;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.delta.EnumMachineDelta;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileWire
extends TileMachineBase
implements IElectricGrid {
    private final IElectricGrid.ChargeHandler chargeHandler = new IElectricGrid.ChargeHandler(this, IElectricGrid.ChargeHandler.ConnectType.WIRE, 0.25);
    private AddonType addon = AddonType.NONE;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineDelta.WIRE;
    }

    @Override
    public IIcon getIcon(int side) {
        return this.getMachineType().getTexture(0);
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        ItemStack current = player.getCurrentEquippedItem();
        if (current != null && InvTools.isStackEqualToBlock(current, BlockFrame.getBlock()) && this.setAddon(AddonType.FRAME)) {
            if (!player.capabilities.isCreativeMode) {
                player.setCurrentItemOrArmor(0, InvTools.depleteItem(current));
            }
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public ArrayList<ItemStack> getDrops(int fortune) {
        ArrayList<ItemStack> drops = super.getDrops(fortune);
        if (this.addon == AddonType.FRAME && BlockFrame.getBlock() != null) {
            drops.add(BlockFrame.getItem());
        }
        return drops;
    }

    @Override
    public boolean isSideSolid(ForgeDirection side) {
        if (this.addon == AddonType.FRAME) {
            return side == ForgeDirection.UP;
        }
        return false;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.chargeHandler.tick();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.chargeHandler.writeToNBT(data);
        data.setString("addonType", this.addon.name());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.chargeHandler.readFromNBT(data);
        this.addon = AddonType.valueOf(data.getString("addonType"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.addon.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.setAddon(AddonType.fromOrdinal(data.readByte()));
        this.markBlockForUpdate();
    }

    public AddonType getAddon() {
        return this.addon;
    }

    public boolean setAddon(AddonType addon) {
        if (this.addon == addon) {
            return false;
        }
        if (this.addon != AddonType.NONE) {
            // empty if block
        }
        this.addon = addon;
        this.sendUpdateToClient();
        return true;
    }

    @Override
    public IElectricGrid.ChargeHandler getChargeHandler() {
        return this.chargeHandler;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public IPostConnection.ConnectStyle connectsToPost(ForgeDirection side) {
        if (this.getAddon() == AddonType.FRAME) {
            return IPostConnection.ConnectStyle.TWO_THIN;
        }
        return IPostConnection.ConnectStyle.NONE;
    }

    public static class WireBoundingBox
    extends BoundingBoxManager.ReducedBoundingBox {
        public WireBoundingBox() {
            super(4);
        }

        @Override
        public AxisAlignedBB getBox(World world, int x, int y, int z) {
            TileWire wire;
            AddonType type;
            TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
            if (tile instanceof TileWire && (type = (wire = (TileWire)tile).getAddon()) == AddonType.NONE) {
                return super.getBox(world, x, y, z);
            }
            return BoundingBoxManager.DEFAULT.getBox(world, x, y, z);
        }
    }

    public static enum AddonType {
        NONE,
        FRAME,
        PYLON;

        public static final AddonType[] VALUES;

        public static AddonType fromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= VALUES.length) {
                return NONE;
            }
            return VALUES[ordinal];
        }

        static {
            VALUES = AddonType.values();
        }
    }
}

