/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.epsilon;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.epsilon.TileAdminSteamProducer;
import mods.railcraft.common.blocks.machine.epsilon.TileElectricFeeder;
import mods.railcraft.common.blocks.machine.epsilon.TileElectricFeederAdmin;
import mods.railcraft.common.blocks.machine.epsilon.TileEngravingBench;
import mods.railcraft.common.blocks.machine.epsilon.TileFluxTransformer;
import mods.railcraft.common.blocks.machine.epsilon.TileForceTrackEmitter;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public enum EnumMachineEpsilon implements IEnumMachine
{
    ELECTRIC_FEEDER(ModuleManager.Module.ELECTRICITY, "electric.feeder", TileElectricFeeder.class, 1, 1, 0),
    ELECTRIC_FEEDER_ADMIN(ModuleManager.Module.ELECTRICITY, "electric.feeder.admin", TileElectricFeederAdmin.class, 2, 1, 0, 0, 0, 0, 0, 0, 1),
    ADMIN_STEAM_PRODUCER(ModuleManager.Module.STEAM, "admin.steam.producer", TileAdminSteamProducer.class, 2, 1, 0, 0, 0, 0, 0, 0, 1),
    FORCE_TRACK_EMITTER(ModuleManager.Module.ELECTRICITY, "force.track.emitter", TileForceTrackEmitter.class, new int[0]),
    FLUX_TRANSFORMER(ModuleManager.Module.ELECTRICITY, "flux.transformer", TileFluxTransformer.class, new int[0]),
    ENGRAVING_BENCH(ModuleManager.Module.EMBLEM, "engraving.bench", TileEngravingBench.class, 4, 1, 0, 1, 3, 3, 3, 3, 2);

    private final ModuleManager.Module module;
    private final String tag;
    private final Class<? extends TileMachineBase> tile;
    private IIcon[] texture = new IIcon[12];
    private final int[] textureInfo;
    private static final List<EnumMachineEpsilon> creativeList;
    private static final EnumMachineEpsilon[] VALUES;
    private ToolTip tip;

    private EnumMachineEpsilon(ModuleManager.Module module, String tag, Class<? extends TileMachineBase> tile, int ... textureInfo) {
        this.module = module;
        this.tile = tile;
        this.tag = tag;
        this.textureInfo = textureInfo;
    }

    public boolean register() {
        if (RailcraftConfig.isSubBlockEnabled(this.getTag())) {
            RailcraftBlocks.registerBlockMachineEpsilon();
            return this.getBlock() != null;
        }
        return false;
    }

    @Override
    public boolean isDepreciated() {
        return this.module == null;
    }

    public void setTexture(IIcon[] tex) {
        this.texture = tex;
    }

    public IIcon[] getTexture() {
        return this.texture;
    }

    @Override
    public IIcon getTexture(int index) {
        if (index < 0 || index >= this.texture.length) {
            index = 0;
        }
        return this.texture[index];
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister iconRegister) {
        for (EnumMachineEpsilon machine : VALUES) {
            if (machine.isDepreciated() || machine.textureInfo.length == 0) continue;
            machine.texture = new IIcon[machine.textureInfo.length - 2];
            int columns = machine.textureInfo[0];
            int rows = machine.textureInfo[1];
            IIcon[] icons = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:" + machine.tag, columns, rows);
            for (int i = 0; i < machine.texture.length; ++i) {
                machine.texture[i] = icons[machine.textureInfo[i + 2]];
            }
        }
        IIcon emitterSide = iconRegister.registerIcon("railcraft:" + EnumMachineEpsilon.FORCE_TRACK_EMITTER.tag + ".side");
        EnumMachineEpsilon.FORCE_TRACK_EMITTER.texture = new IIcon[9];
        Arrays.fill(EnumMachineEpsilon.FORCE_TRACK_EMITTER.texture, emitterSide);
        EnumMachineEpsilon.FORCE_TRACK_EMITTER.texture[6] = iconRegister.registerIcon("railcraft:" + EnumMachineEpsilon.FORCE_TRACK_EMITTER.tag + ".side.unpowered");
        EnumMachineEpsilon.FORCE_TRACK_EMITTER.texture[7] = iconRegister.registerIcon("railcraft:" + EnumMachineEpsilon.FORCE_TRACK_EMITTER.tag + ".facing");
        EnumMachineEpsilon.FORCE_TRACK_EMITTER.texture[8] = iconRegister.registerIcon("railcraft:" + EnumMachineEpsilon.FORCE_TRACK_EMITTER.tag + ".facing.unpowered");
        IIcon transformerSide = iconRegister.registerIcon("railcraft:" + EnumMachineEpsilon.FLUX_TRANSFORMER.tag + ".side");
        IIcon transformerCap = iconRegister.registerIcon("railcraft:" + EnumMachineEpsilon.FLUX_TRANSFORMER.tag + ".cap");
        EnumMachineEpsilon.FLUX_TRANSFORMER.texture = new IIcon[6];
        Arrays.fill(EnumMachineEpsilon.FLUX_TRANSFORMER.texture, transformerSide);
        EnumMachineEpsilon.FLUX_TRANSFORMER.texture[0] = transformerCap;
        EnumMachineEpsilon.FLUX_TRANSFORMER.texture[1] = transformerCap;
    }

    public static EnumMachineEpsilon fromId(int id) {
        if (id < 0 || id >= VALUES.length) {
            id = 0;
        }
        return VALUES[id];
    }

    public static List<EnumMachineEpsilon> getCreativeList() {
        return creativeList;
    }

    @Override
    public String getTag() {
        return "tile.railcraft.machine.epsilon." + this.tag;
    }

    @Override
    public Class getTileClass() {
        return this.tile;
    }

    @Override
    public TileMachineBase getTileEntity() {
        try {
            return this.tile.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public ItemStack getItem() {
        return this.getItem(1);
    }

    @Override
    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    public ModuleManager.Module getModule() {
        return this.module;
    }

    @Override
    public Block getBlock() {
        return RailcraftBlocks.getBlockMachineEpsilon();
    }

    @Override
    public boolean isAvaliable() {
        return ModuleManager.isModuleLoaded(this.getModule()) && this.getBlock() != null && RailcraftConfig.isSubBlockEnabled(this.getTag());
    }

    @Override
    public ToolTip getToolTip(ItemStack stack, EntityPlayer player, boolean adv) {
        if (this.tip != null) {
            return this.tip;
        }
        String tipTag = this.getTag() + ".tip";
        if (LocalizationPlugin.hasTag(tipTag)) {
            this.tip = ToolTip.buildToolTip(tipTag, new String[0]);
        }
        return this.tip;
    }

    static {
        creativeList = new ArrayList<EnumMachineEpsilon>();
        VALUES = EnumMachineEpsilon.values();
        creativeList.add(ELECTRIC_FEEDER);
        creativeList.add(ELECTRIC_FEEDER_ADMIN);
        creativeList.add(FLUX_TRANSFORMER);
        creativeList.add(FORCE_TRACK_EMITTER);
        creativeList.add(ADMIN_STEAM_PRODUCER);
        creativeList.add(ENGRAVING_BENCH);
    }
}

