/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.epsilon;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.electricity.IElectricGrid;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.epsilon.EnumMachineEpsilon;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public class TileElectricFeederAdmin
extends TileMachineBase
implements IElectricGrid {
    private final IElectricGrid.ChargeHandler chargeHandler = new IElectricGrid.ChargeHandler(this, IElectricGrid.ChargeHandler.ConnectType.BLOCK, 0.0);
    private boolean powered;

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        this.checkRedstone();
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        this.checkRedstone();
    }

    private void checkRedstone() {
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean p = PowerPlugin.isBlockBeingPowered(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        if (this.powered != p) {
            this.powered = p;
            this.sendUpdateToClient();
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (this.powered) {
            double capacity = this.chargeHandler.getCapacity();
            try {
                this.chargeHandler.setCharge(capacity);
            }
            catch (Throwable err) {
                this.chargeHandler.addCharge(capacity - this.chargeHandler.getCharge());
                Game.logErrorAPI("Railcraft", err, IElectricGrid.class);
            }
        }
        this.chargeHandler.tick();
    }

    @Override
    public IElectricGrid.ChargeHandler getChargeHandler() {
        return this.chargeHandler;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineEpsilon.ELECTRIC_FEEDER_ADMIN;
    }

    @Override
    public IIcon getIcon(int side) {
        return this.getMachineType().getTexture(this.powered ? 0 : 6);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.chargeHandler.readFromNBT(data);
        this.powered = data.getBoolean("powered");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.chargeHandler.writeToNBT(data);
        data.setBoolean("powered", this.powered);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean p = data.readBoolean();
        if (this.powered != p) {
            this.powered = p;
            this.markBlockForUpdate();
        }
    }
}

