/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.epsilon;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.electricity.IElectricGrid;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackLockdown;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.epsilon.EnumMachineEpsilon;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TrackForce;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileForceTrackEmitter
extends TileMachineBase
implements IElectricGrid {
    private static final double BASE_DRAW = 22.0;
    private static final double CHARGE_PER_TRACK = 2.0;
    private static final int TICKS_PER_ACTION = 4;
    private static final int TICKS_PER_REFRESH = 64;
    public static final int MAX_TRACKS = 64;
    private final IElectricGrid.ChargeHandler chargeHandler = new IElectricGrid.ChargeHandler(this, IElectricGrid.ChargeHandler.ConnectType.BLOCK, 0.0);
    private boolean powered;
    private ForgeDirection facing = ForgeDirection.NORTH;
    private int numTracks;
    private State state = State.RETRACTED;

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        this.checkRedstone();
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        this.facing = MiscTools.getHorizontalSideClosestToPlayer(this.worldObj, this.xCoord, this.yCoord, this.zCoord, entityliving);
        this.checkRedstone();
    }

    private void checkRedstone() {
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean p = PowerPlugin.isBlockBeingPowered(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        if (this.powered != p) {
            this.powered = p;
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        while (this.numTracks > 0) {
            int x = this.xCoord + this.numTracks * this.facing.offsetX;
            int y = this.yCoord + 1;
            int z = this.zCoord + this.numTracks * this.facing.offsetZ;
            this.removeTrack(x, y, z);
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        double draw = TileForceTrackEmitter.getDraw(this.numTracks);
        if (this.powered && this.chargeHandler.removeCharge(draw) >= draw) {
            switch (this.state) {
                case RETRACTING: 
                case RETRACTED: 
                case HALTED: {
                    this.state = State.EXTENDING;
                    break;
                }
                case EXTENDED: {
                    if (this.clock % 64 != 0) break;
                    this.state = State.EXTENDING;
                }
            }
        } else if (this.state == State.EXTENDED || this.state == State.EXTENDING || this.state == State.HALTED) {
            this.state = State.RETRACTING;
        }
        this.state.doAction(this);
        this.chargeHandler.tick();
    }

    private void spawnParticles(int x, int y, int z) {
        EffectManager.instance.forceTrackSpawnEffect(this.worldObj, x, y, z);
    }

    private void extended() {
        TileTrack trackTile;
        ITrackInstance track;
        TileEntity tile = this.tileCache.getTileOnSide(ForgeDirection.UP);
        if (tile instanceof TileTrack && (track = (trackTile = (TileTrack)tile).getTrackInstance()) instanceof ITrackLockdown) {
            ((ITrackLockdown)track).releaseCart();
        }
    }

    private void extend() {
        if (!this.hasPowerToExtend()) {
            this.state = State.HALTED;
        }
        if (this.numTracks >= 64) {
            this.state = State.EXTENDED;
        } else if (this.clock % 4 == 0) {
            int x = this.xCoord + (this.numTracks + 1) * this.facing.offsetX;
            int y = this.yCoord + 1;
            int z = this.zCoord + (this.numTracks + 1) * this.facing.offsetZ;
            if (WorldPlugin.blockExists(this.worldObj, x, y, z)) {
                EnumTrackMeta meta;
                Block block = WorldPlugin.getBlock((IBlockAccess)this.worldObj, x, y, z);
                if (!this.placeTrack(x, y, z, block, meta = this.facing == ForgeDirection.NORTH || this.facing == ForgeDirection.SOUTH ? EnumTrackMeta.NORTH_SOUTH : EnumTrackMeta.EAST_WEST) && !this.claimTrack(x, y, z, block, meta)) {
                    this.state = State.EXTENDED;
                }
            } else {
                this.state = State.HALTED;
            }
        }
    }

    private boolean placeTrack(int x, int y, int z, Block block, EnumTrackMeta meta) {
        if (WorldPlugin.blockIsAir(this.worldObj, x, y, z, block)) {
            this.spawnParticles(x, y, z);
            TileTrack track = TrackTools.placeTrack(EnumTrack.FORCE.getTrackSpec(), this.worldObj, x, y, z, meta.ordinal());
            ((TrackForce)track.getTrackInstance()).setEmitter(this);
            ++this.numTracks;
            return true;
        }
        return false;
    }

    private boolean claimTrack(int x, int y, int z, Block block, EnumTrackMeta meta) {
        if (block != RailcraftBlocks.getBlockTrack()) {
            return false;
        }
        if (TrackTools.getTrackMetaEnum((IBlockAccess)this.worldObj, block, null, x, y, z) != meta) {
            return false;
        }
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)this.worldObj, x, y, z);
        if (!TrackTools.isTrackSpec(tile, EnumTrack.FORCE.getTrackSpec())) {
            return false;
        }
        TrackForce track = (TrackForce)((TileTrack)tile).getTrackInstance();
        TileForceTrackEmitter emitter = track.getEmitter();
        if (emitter == null || emitter == this) {
            track.setEmitter(this);
            ++this.numTracks;
            return true;
        }
        return false;
    }

    public int getNumberOfTracks() {
        return this.numTracks;
    }

    public static double getDraw(int tracks) {
        return 22.0 + 2.0 * (double)tracks;
    }

    public boolean hasPowerToExtend() {
        return this.chargeHandler.getCharge() >= TileForceTrackEmitter.getDraw(this.numTracks + 1);
    }

    private void retract() {
        if (this.numTracks <= 0) {
            this.state = State.RETRACTED;
        } else if (this.clock % 4 == 0) {
            int x = this.xCoord + this.numTracks * this.facing.offsetX;
            int y = this.yCoord + 1;
            int z = this.zCoord + this.numTracks * this.facing.offsetZ;
            this.removeTrack(x, y, z);
        }
    }

    private void removeTrack(int x, int y, int z) {
        if (WorldPlugin.blockExists(this.worldObj, x, y, z) && TrackTools.isTrackAt((IBlockAccess)this.worldObj, x, y, z, EnumTrack.FORCE)) {
            this.spawnParticles(x, y, z);
            WorldPlugin.setBlockToAir(this.worldObj, x, y, z);
        }
        --this.numTracks;
    }

    @Override
    public IElectricGrid.ChargeHandler getChargeHandler() {
        return this.chargeHandler;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineEpsilon.FORCE_TRACK_EMITTER;
    }

    @Override
    public IIcon getIcon(int side) {
        if (side == this.facing.ordinal()) {
            return this.getMachineType().getTexture(this.powered ? 7 : 8);
        }
        return this.getMachineType().getTexture(this.powered ? 0 : 6);
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        if (Game.isNotHost(this.worldObj)) {
            return false;
        }
        if (this.state != State.RETRACTED) {
            return false;
        }
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            return false;
        }
        this.facing = this.facing == axis ? axis.getOpposite() : axis;
        this.numTracks = 0;
        this.markBlockForUpdate();
        this.notifyBlocksOfNeighborChange();
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.chargeHandler.writeToNBT(data);
        data.setBoolean("powered", this.powered);
        data.setByte("facing", (byte)this.facing.ordinal());
        data.setInteger("numTracks", this.numTracks);
        data.setString("state", this.state.name());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.chargeHandler.readFromNBT(data);
        this.powered = data.getBoolean("powered");
        this.facing = ForgeDirection.getOrientation((int)data.getByte("facing"));
        this.numTracks = data.getInteger("numTracks");
        this.state = State.valueOf(data.getString("state"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeByte((byte)this.facing.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        byte f;
        super.readPacketData(data);
        boolean update = false;
        boolean p = data.readBoolean();
        if (this.powered != p) {
            this.powered = p;
            update = true;
        }
        if (this.facing != ForgeDirection.getOrientation((int)(f = data.readByte()))) {
            this.facing = ForgeDirection.getOrientation((int)f);
            update = true;
        }
        if (update) {
            this.markBlockForUpdate();
        }
    }

    public ForgeDirection getFacing() {
        return this.facing;
    }

    private static enum State {
        EXTENDED,
        RETRACTED,
        EXTENDING,
        RETRACTING,
        HALTED;


        private void doAction(TileForceTrackEmitter emitter) {
            switch (this) {
                case EXTENDING: {
                    emitter.extend();
                    break;
                }
                case RETRACTING: {
                    emitter.retract();
                    break;
                }
                case EXTENDED: {
                    emitter.extended();
                }
            }
        }
    }
}

