/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.util.Map;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.items.IMinecartItem;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileDispenserCart;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.carts.ItemCartAnchor;
import mods.railcraft.common.carts.ItemLocomotive;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.PhantomInventory;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.WorldServer;

public class TileDispenserTrain
extends TileDispenserCart {
    public static final int PATTERN_SIZE = 9;
    public static final int BUFFER_SIZE = 18;
    private byte patternIndex;
    private boolean spawningTrain = false;
    private EntityMinecart lastCart;
    private final PhantomInventory invPattern = new PhantomInventory(9, this);
    private final IInventory invStock;

    public TileDispenserTrain() {
        this.setInventorySize(18);
        this.invStock = new InventoryMapper(this);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.DISPENSER_TRAIN;
    }

    public PhantomInventory getPattern() {
        return this.invPattern;
    }

    @Override
    public IIcon getIcon(int side) {
        if (this.direction.ordinal() == side) {
            return this.getMachineType().getTexture(3);
        }
        if (side != 0 && side != 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(1);
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.TRAIN_DISPENSER, player, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    private boolean canBuildTrain() {
        Map<ItemStack, Integer> pattern = InvTools.getManifest(this.getPattern());
        Map<ItemStack, Integer> buffer = InvTools.getManifest(this);
        for (Map.Entry<ItemStack, Integer> entry : pattern.entrySet()) {
            Integer count = buffer.get(entry.getKey());
            if (count != null && count >= entry.getValue()) continue;
            return false;
        }
        return true;
    }

    private boolean spawnNextCart() {
        ItemStack cartItem;
        ItemStack spawn = this.getPattern().getStackInSlot(this.patternIndex);
        if (spawn == null) {
            this.resetSpawnSequence();
            return false;
        }
        MinecartItemType filter = new MinecartItemType(spawn);
        if (InvTools.countItems(this.invStock, filter) == 0) {
            this.resetSpawnSequence();
            return false;
        }
        int x = MiscTools.getXOnSide(this.xCoord, this.direction);
        int y = MiscTools.getYOnSide(this.yCoord, this.direction);
        int z = MiscTools.getZOnSide(this.zCoord, this.direction);
        if ((spawn.getItem() instanceof ItemMinecart || spawn.getItem() instanceof IMinecartItem) && CartTools.getMinecartOnSide(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 0.0f, this.direction) == null && (cartItem = InvTools.removeOneItem(this.invStock, (IStackFilter)filter)) != null) {
            EntityMinecart cartPlaced = CartUtils.placeCart(this.getOwner(), cartItem, (WorldServer)this.worldObj, x, y, z);
            if (cartPlaced != null) {
                CartTools.getLinkageManager(this.worldObj).createLink(cartPlaced, this.lastCart);
                this.lastCart = cartPlaced;
                this.patternIndex = (byte)(this.patternIndex + 1);
                if (this.patternIndex >= this.getPattern().getSizeInventory()) {
                    this.resetSpawnSequence();
                }
                return true;
            }
            InvTools.moveItemStack(cartItem, this.invStock);
        }
        return false;
    }

    private void resetSpawnSequence() {
        this.patternIndex = 0;
        this.spawningTrain = false;
        this.timeSinceLastSpawn = 0;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.spawningTrain && this.clock % 4 == 0) {
            this.spawnNextCart();
        }
    }

    @Override
    public void onPulse() {
        EntityMinecart cart = CartTools.getMinecartOnSide(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 0.0f, this.direction);
        if (cart == null && !this.spawningTrain && this.canBuildTrain() && this.timeSinceLastSpawn > RailcraftConfig.getCartDispenserMinDelay() * 20) {
            this.spawningTrain = true;
        }
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("spawningTrain", this.spawningTrain);
        data.setByte("patternIndex", this.patternIndex);
        this.getPattern().writeToNBT("invPattern", data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.spawningTrain = data.getBoolean("spawningTrain");
        this.patternIndex = data.getByte("patternIndex");
        if (data.hasKey("pattern")) {
            NBTTagCompound pattern = data.getCompoundTag("pattern");
            this.getPattern().readFromNBT("Items", pattern);
        } else {
            this.getPattern().readFromNBT("invPattern", data);
        }
    }

    private static class MinecartItemType
    implements IStackFilter {
        private final ItemStack original;

        public MinecartItemType(ItemStack cart) {
            this.original = cart;
        }

        @Override
        public boolean matches(ItemStack stack) {
            if (stack == null) {
                return false;
            }
            if (InvTools.isItemEqual(stack, this.original)) {
                return true;
            }
            if (stack.getItem() instanceof ItemCartAnchor || stack.getItem() instanceof ItemLocomotive) {
                return InvTools.isItemEqual(stack, this.original, false, false);
            }
            return false;
        }
    }
}

