/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderFluidBase;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.TankToolkit;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.buttons.IButtonTextureSet;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.gui.buttons.StandardButtonTextureSets;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileFluidUnloader
extends TileLoaderFluidBase
implements IGuiReturnHandler {
    private static final int TRANSFER_RATE = 80;
    private final MultiButtonController<ButtonState> stateController = new MultiButtonController(ButtonState.EMPTY_COMPLETELY.ordinal(), (IMultiButtonState[])ButtonState.values());

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.FLUID_UNLOADER;
    }

    public MultiButtonController<ButtonState> getStateController() {
        return this.stateController;
    }

    @Override
    public IIcon getIcon(int side) {
        if (side > 1) {
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        return super.blockActivated(player, side);
    }

    @Override
    public void updateEntity() {
        ItemStack bottomSlot;
        super.updateEntity();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.flow = 0;
        ItemStack topSlot = this.getStackInSlot(0);
        if (topSlot != null && !FluidItemHelper.isContainer(topSlot)) {
            this.setInventorySlotContents(0, null);
            this.dropItem(topSlot);
        }
        if ((bottomSlot = this.getStackInSlot(1)) != null && !FluidItemHelper.isContainer(bottomSlot)) {
            this.setInventorySlotContents(1, null);
            this.dropItem(bottomSlot);
        }
        if (this.clock % 8 == 0) {
            FluidHelper.fillContainers(this.tankManager, this, 0, 1, this.loaderTank.getFluidType());
        }
        this.tankManager.outputLiquid(this.tileCache, TankManager.TANK_FILTER, ForgeDirection.VALID_DIRECTIONS, 0, 80);
        EntityMinecart cart = CartTools.getMinecartOnSide(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 0.1f, ForgeDirection.UP);
        if (cart != this.currentCart) {
            this.setPowered(false);
            this.currentCart = cart;
            this.cartWasSent();
        }
        if (cart == null) {
            return;
        }
        if (!this.canHandleCart(cart)) {
            this.sendCart(cart);
            return;
        }
        if (this.isPaused()) {
            return;
        }
        TankToolkit tankCart = new TankToolkit((IFluidHandler)cart);
        FluidStack drained = tankCart.drain(ForgeDirection.DOWN, RailcraftConfig.getTankCartFillRate(), false);
        if (this.getFilterFluid() == null || Fluids.areEqual(this.getFilterFluid(), drained)) {
            this.flow = this.tankManager.get(0).fill(drained, true);
            tankCart.drain(ForgeDirection.DOWN, this.flow, true);
        }
        if (this.flow > 0) {
            this.setPowered(false);
        }
        if (!this.isManualMode() && this.flow <= 0 && !this.isPowered() && this.shouldSendCart(cart)) {
            this.sendCart(cart);
        }
    }

    @Override
    protected boolean shouldSendCart(EntityMinecart cart) {
        if (!(cart instanceof IFluidHandler)) {
            return true;
        }
        TankToolkit tankCart = new TankToolkit((IFluidHandler)cart);
        if (this.stateController.getButtonState() == ButtonState.IMMEDIATE) {
            return true;
        }
        if (this.getFilterFluid() != null && tankCart.isTankEmpty(this.getFilterFluid())) {
            return true;
        }
        return tankCart.areTanksEmpty();
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.stateController.writeToNBT(data, "state");
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.stateController.readFromNBT(data, "state");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.stateController.getCurrentState());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.stateController.setCurrentState(data.readByte());
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.stateController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.stateController.setCurrentState(data.readByte());
    }

    public ForgeDirection getOrientation() {
        return ForgeDirection.UP;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.UNLOADER_FLUID, player, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return FluidItemHelper.isEmptyContainer(stack);
            }
        }
        return false;
    }

    @Override
    public boolean isManualMode() {
        return this.stateController.getButtonState() == ButtonState.MANUAL;
    }

    public static enum ButtonState implements IMultiButtonState
    {
        EMPTY_COMPLETELY("railcraft.gui.liquid.unloader.empty"),
        IMMEDIATE("railcraft.gui.liquid.unloader.immediate"),
        MANUAL("railcraft.gui.liquid.unloader.manual");

        private final String label;
        private final ToolTip tip;

        private ButtonState(String label) {
            this.label = label;
            this.tip = ToolTip.buildToolTip(label + ".tip", new String[0]);
        }

        @Override
        public String getLabel() {
            return LocalizationPlugin.translate(this.label);
        }

        @Override
        public IButtonTextureSet getTextureSet() {
            return StandardButtonTextureSets.SMALL_BUTTON;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }
}

