/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import buildcraft.api.statements.IActionExternal;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasCart;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasWork;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.PhantomInventory;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileLoaderBase
extends TileMachineItem
implements IHasCart,
IHasWork {
    public static final float STOP_VELOCITY = 0.02f;
    public static final int PAUSE_DELAY = 4;
    private final PhantomInventory invCarts = new PhantomInventory(2, this);
    protected EntityMinecart currentCart;
    private boolean powered;
    private boolean sendCartGateAction = false;
    private int pause = 0;

    @Override
    public boolean hasMinecart() {
        return this.currentCart != null;
    }

    public abstract boolean canHandleCart(EntityMinecart var1);

    @Override
    public boolean hasWork() {
        return this.currentCart != null && this.canHandleCart(this.currentCart) && (this.isProcessing() || !this.shouldSendCart(this.currentCart));
    }

    public abstract boolean isManualMode();

    public abstract boolean isProcessing();

    protected abstract boolean shouldSendCart(EntityMinecart var1);

    protected void sendCart(EntityMinecart cart) {
        if (cart == null) {
            return;
        }
        if (this.isManualMode()) {
            return;
        }
        if (CartTools.cartVelocityIsLessThan(cart, 0.02f) || cart.isPoweredCart()) {
            this.setPowered(true);
        }
    }

    public final boolean isPowered() {
        return this.powered;
    }

    protected void setPowered(boolean p) {
        if (this.isManualMode()) {
            p = false;
        }
        if (this.powered != p) {
            this.powered = p;
            this.notifyBlocksOfNeighborChange();
        }
    }

    public final PhantomInventory getCartFilters() {
        return this.invCarts;
    }

    @Override
    public void actionActivated(IActionExternal action) {
        if (action == Actions.SEND_CART) {
            this.sendCartGateAction = true;
        }
        if (action == Actions.PAUSE) {
            this.pause = 4;
        }
    }

    public boolean isSendCartGateAction() {
        return this.sendCartGateAction;
    }

    public void cartWasSent() {
        this.sendCartGateAction = false;
    }

    public boolean isPaused() {
        return this.pause > 0;
    }

    @Override
    public final boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (this.pause > 0) {
            --this.pause;
        }
    }

    @Override
    public final boolean canConnectRedstone(int dir) {
        return true;
    }

    @Override
    public final boolean isPoweringTo(int side) {
        if (!this.isPowered()) {
            return false;
        }
        ForgeDirection opSide = MiscTools.getOppositeSide(side);
        Block block = WorldPlugin.getBlockOnSide((IBlockAccess)this.worldObj, this.xCoord, this.yCoord, this.zCoord, opSide);
        return TrackTools.isRailBlock(block) || block == Blocks.redstone_wire || block == Blocks.powered_repeater || block == Blocks.unpowered_repeater;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("powered", this.powered);
        this.getCartFilters().writeToNBT("invCarts", data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.setPowered(data.getBoolean("powered"));
        this.getCartFilters().readFromNBT("invCarts", data);
    }
}

